/*
 * Decompiled with CFR 0.152.
 */
package com.helger.db.jdbc.executor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGetterDirectTrait;
import com.helger.db.api.jdbc.JDBCHelper;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DBResultField
implements IGetterDirectTrait,
Serializable {
    private final String m_sColumnName;
    private final int m_nColumnType;
    private final Object m_aValue;

    public DBResultField(@Nonnull @Nonempty String string, int n, @Nullable Object object) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ColumnName");
        this.m_sColumnName = string;
        this.m_nColumnType = n;
        this.m_aValue = object;
    }

    @Nonnull
    @Nonempty
    public String getColumnName() {
        return this.m_sColumnName;
    }

    public int getColumnType() {
        return this.m_nColumnType;
    }

    @Nullable
    public String getColumnTypeName() {
        return JDBCHelper.getJDBCTypeName((int)this.m_nColumnType);
    }

    @Nullable
    public Object getValue() {
        return this.m_aValue;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ColumnName", (Object)this.m_sColumnName).append("ColumnType", this.m_nColumnType).append("Value", this.m_aValue).getToString();
    }
}

