/*
 * Decompiled with CFR 0.152.
 */
package com.helger.db.jdbc.executor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.db.jdbc.executor.DBResultField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DBResultRow
implements ICloneable<DBResultRow>,
Serializable {
    private final DBResultField[] m_aCols;
    private int m_nIndex;

    protected DBResultRow(@Nonnull DBResultRow dBResultRow) {
        this.m_aCols = (DBResultField[])ArrayHelper.getCopy((Object[])dBResultRow.m_aCols);
        this.m_nIndex = dBResultRow.m_nIndex;
    }

    public DBResultRow(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Columns");
        this.m_aCols = new DBResultField[n];
        this.m_nIndex = 0;
    }

    protected void internalClear() {
        for (int i = 0; i < this.m_aCols.length; ++i) {
            this.m_aCols[i] = null;
        }
        this.m_nIndex = 0;
    }

    protected void internalAdd(@Nonnull DBResultField dBResultField) {
        ValueEnforcer.notNull((Object)dBResultField, (String)"ResultField");
        this.m_aCols[this.m_nIndex++] = dBResultField;
    }

    @Nonnegative
    public int getUsedColumnIndex() {
        return this.m_nIndex;
    }

    @Nonnegative
    public int getColumnCount() {
        return this.m_aCols.length;
    }

    @Nullable
    public DBResultField get(@Nonnegative int n) {
        return this.m_aCols[n];
    }

    public int getColumnType(@Nonnegative int n) {
        return this.get(n).getColumnType();
    }

    @Nullable
    public String getColumnTypeName(@Nonnegative int n) {
        return this.get(n).getColumnTypeName();
    }

    @Nonnull
    @Nonempty
    public String getColumnName(@Nonnegative int n) {
        return this.get(n).getColumnName();
    }

    @Nullable
    public Object getValue(@Nonnegative int n) {
        return this.get(n).getValue();
    }

    @Nullable
    public String getAsString(@Nonnegative int n) {
        return this.get(n).getAsString();
    }

    @Nullable
    public BigDecimal getAsBigDecimal(@Nonnegative int n) {
        return this.get(n).getAsBigDecimal();
    }

    @Nullable
    public BigInteger getAsBigInteger(@Nonnegative int n) {
        return this.get(n).getAsBigInteger();
    }

    public boolean getAsBoolean(@Nonnegative int n) {
        return this.get(n).getAsBoolean();
    }

    public boolean getAsBoolean(@Nonnegative int n, boolean bl) {
        return this.get(n).getAsBoolean(bl);
    }

    public byte getAsByte(@Nonnegative int n) {
        return this.get(n).getAsByte();
    }

    public byte getAsByte(@Nonnegative int n, byte by) {
        return this.get(n).getAsByte(by);
    }

    @Nullable
    public byte[] getAsByteArray(@Nonnegative int n) {
        return this.get(n).getAsByteArray();
    }

    public char getAsChar(@Nonnegative int n) {
        return this.get(n).getAsChar();
    }

    public char getAsChar(@Nonnegative int n, char c) {
        return this.get(n).getAsChar(c);
    }

    public double getAsDouble(@Nonnegative int n) {
        return this.get(n).getAsDouble();
    }

    public double getAsDouble(@Nonnegative int n, double d) {
        return this.get(n).getAsDouble(d);
    }

    public float getAsFloat(@Nonnegative int n) {
        return this.get(n).getAsFloat();
    }

    public float getAsFloat(@Nonnegative int n, float f) {
        return this.get(n).getAsFloat(f);
    }

    public int getAsInt(@Nonnegative int n) {
        return this.get(n).getAsInt();
    }

    public int getAsInt(@Nonnegative int n, int n2) {
        return this.get(n).getAsInt(n2);
    }

    public long getAsLong(@Nonnegative int n) {
        return this.get(n).getAsLong();
    }

    public long getAsLong(@Nonnegative int n, long l) {
        return this.get(n).getAsLong(l);
    }

    public short getAsShort(@Nonnegative int n) {
        return this.get(n).getAsShort();
    }

    public short getAsShort(@Nonnegative int n, short s) {
        return this.get(n).getAsShort(s);
    }

    @Nullable
    public Boolean getAsBooleanObj(@Nonnegative int n) {
        return this.get(n).getAsBooleanObj();
    }

    @Nullable
    public Byte getAsByteObj(@Nonnegative int n) {
        return this.get(n).getAsByteObj();
    }

    @Nullable
    public Character getAsCharObj(@Nonnegative int n) {
        return this.get(n).getAsCharObj();
    }

    @Nullable
    public Double getAsDoubleObj(@Nonnegative int n) {
        return this.get(n).getAsDoubleObj();
    }

    @Nullable
    public Float getAsFloatObj(@Nonnegative int n) {
        return this.get(n).getAsFloatObj();
    }

    @Nullable
    public Integer getAsIntObj(@Nonnegative int n) {
        return this.get(n).getAsIntObj();
    }

    @Nullable
    public Long getAsLongObj(@Nonnegative int n) {
        return this.get(n).getAsLongObj();
    }

    @Nullable
    public Short getAsShortObj(@Nonnegative int n) {
        return this.get(n).getAsShortObj();
    }

    @Nullable
    public Blob getAsBlob(@Nonnegative int n) {
        return this.get(n).getAsSqlBlob();
    }

    @Nullable
    public Clob getAsClob(@Nonnegative int n) {
        return this.get(n).getAsSqlClob();
    }

    @Nullable
    public Date getAsDate(@Nonnegative int n) {
        return this.get(n).getAsSqlDate();
    }

    @Nullable
    public LocalDate getAsLocalDate(@Nonnegative int n) {
        Date date = this.getAsDate(n);
        return date == null ? null : date.toLocalDate();
    }

    @Nullable
    public NClob getAsNClob(@Nonnegative int n) {
        return this.get(n).getAsSqlNClob();
    }

    @Nullable
    public RowId getAsRowId(@Nonnegative int n) {
        return this.get(n).getAsSqlRowId();
    }

    @Nullable
    public Time getAsTime(@Nonnegative int n) {
        return this.get(n).getAsSqlTime();
    }

    @Nullable
    public LocalTime getAsLocalTime(@Nonnegative int n) {
        Time time = this.getAsTime(n);
        return time == null ? null : time.toLocalTime();
    }

    @Nullable
    public Timestamp getAsTimestamp(@Nonnegative int n) {
        return this.get(n).getAsSqlTimestamp();
    }

    @Nullable
    public LocalDateTime getAsLocalDateTime(@Nonnegative int n) {
        Timestamp timestamp = this.getAsTimestamp(n);
        return timestamp == null ? null : timestamp.toLocalDateTime();
    }

    @Nullable
    public OffsetDateTime getAsOffsetDateTime(@Nonnegative int n) {
        Timestamp timestamp = this.getAsTimestamp(n);
        return timestamp == null ? null : PDTFactory.createOffsetDateTime((Timestamp)timestamp);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, Integer> getColumnNameToIndexMap() {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (int i = 0; i < this.m_aCols.length; ++i) {
            commonsHashMap.put((Object)this.m_aCols[i].getColumnName(), (Object)i);
        }
        return commonsHashMap;
    }

    @Nonnull
    public DBResultRow getClone() {
        return new DBResultRow(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Cols", (Object[])this.m_aCols).append("Index", this.m_nIndex).getToString();
    }
}

