/*
 * Decompiled with CFR 0.152.
 */
package com.helger.db.jdbc.h2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.db.jdbc.AbstractDBConnector;
import com.helger.db.jdbc.executor.DBExecutor;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractH2Connector
extends AbstractDBConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractH2Connector.class);

    @Override
    @Nonnull
    @Nonempty
    protected final String getJDBCDriverClassName() {
        return "org.h2.Driver";
    }

    @Nonnull
    public final ESuccess dumpDatabase(@Nonnull File file) {
        return this.dumpDatabase(FileHelper.getOutputStream((File)file));
    }

    /*
     * Loose catch block
     */
    @Nonnull
    public final ESuccess dumpDatabase(@Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        try {
            LOGGER.info("Dumping database to OutputStream");
            try (PrintWriter printWriter = new PrintWriter((Writer)new NonBlockingBufferedWriter((Writer)StreamHelper.createWriter((OutputStream)outputStream, (Charset)StandardCharsets.UTF_8)));){
                DBExecutor dBExecutor = new DBExecutor(this);
                ESuccess eSuccess = dBExecutor.queryAll("SCRIPT SIMPLE", dBResultRow -> {
                    if (dBResultRow != null) {
                        printWriter.println(dBResultRow.get(0).getValue());
                    }
                });
                printWriter.flush();
                ESuccess eSuccess2 = eSuccess;
                return eSuccess2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    @Nonnull
    public final ESuccess createBackup(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"DestFile");
        LOGGER.info("Backing up database to " + file);
        DBExecutor dBExecutor = new DBExecutor(this);
        return dBExecutor.executeStatement("BACKUP TO '" + file.getAbsolutePath() + "'");
    }
}

