/*
 * Decompiled with CFR 0.152.
 */
package com.helger.db.jdbc.h2;

import com.helger.commons.string.ToStringGenerator;
import java.sql.SQLException;
import org.h2.api.DatabaseEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingH2EventListener
implements DatabaseEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingH2EventListener.class);

    public void init(String string) {
        LOGGER.info("init(" + string + ")");
    }

    public void opened() {
        LOGGER.info("opened()");
    }

    public void diskSpaceIsLow() {
        LOGGER.info("diskSpaceIsLow()");
    }

    public void exceptionThrown(SQLException sQLException, String string) {
        LOGGER.error("exceptionThrown(" + string + ")", (Throwable)sQLException);
    }

    private static String _getStateName(int n) {
        switch (n) {
            case 0: {
                return "scan_file";
            }
            case 1: {
                return "create_index";
            }
            case 2: {
                return "recover";
            }
            case 3: {
                return "backup";
            }
            case 4: {
                return "reconnected";
            }
        }
        return Integer.toString(n);
    }

    public void setProgress(int n, String string, int n2, int n3) {
        LOGGER.info("setProgress(" + LoggingH2EventListener._getStateName(n) + "," + string + "," + n2 + "," + n3 + ")");
    }

    public void closingDatabase() {
        LOGGER.info("closingDatabase()");
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

