/*
 * Decompiled with CFR 0.152.
 */
package com.helger.font;

import com.helger.font.IFontWeight;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public enum EFontWeight implements IFontWeight
{
    HAIRLINE(90),
    THIN(100),
    EXTRA_LIGHT(200),
    LIGHT(300),
    REGULAR(400),
    MEDIUM(500),
    SEMI_BOLD(600),
    BOLD(700),
    EXTRA_BOLD(800),
    BLACK(900);

    private final int m_nWeight;

    private EFontWeight(int n2) {
        this.m_nWeight = n2;
    }

    @Override
    @Nonnegative
    public int getWeight() {
        return this.m_nWeight;
    }

    @Nullable
    public static IFontWeight getFromWeightOrNull(@Nonnegative int n) {
        return EFontWeight.getFromWeightOrDefault(n, null);
    }

    @Nullable
    public static IFontWeight getFromWeightOrDefault(@Nonnegative int n, @Nullable IFontWeight iFontWeight) {
        for (EFontWeight eFontWeight : EFontWeight.values()) {
            if (eFontWeight.getWeight() != n) continue;
            return eFontWeight;
        }
        return iFontWeight;
    }
}

