/*
 * Decompiled with CFR 0.152.
 */
package com.helger.genericode.excel;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.genericode.Genericode04Helper;
import com.helger.genericode.excel.ExcelReadColumn;
import com.helger.genericode.excel.ExcelReadOptions;
import com.helger.genericode.v04.Annotation;
import com.helger.genericode.v04.AnyOtherContent;
import com.helger.genericode.v04.CodeListDocument;
import com.helger.genericode.v04.Column;
import com.helger.genericode.v04.ColumnSet;
import com.helger.genericode.v04.Identification;
import com.helger.genericode.v04.ObjectFactory;
import com.helger.genericode.v04.Row;
import com.helger.genericode.v04.SimpleCodeList;
import com.helger.genericode.v04.UseType;
import com.helger.genericode.v04.Value;
import com.helger.poi.excel.ExcelReadHelper;
import java.io.Serializable;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;

@Immutable
public final class ExcelSheetToCodeList04 {
    public static final String ANNOTATION_NS = "urn:www.helger.com:schemas:genericode-ext";
    public static final QName QNAME_ANNOTATION = new QName("urn:www.helger.com:schemas:genericode-ext", "info");

    private ExcelSheetToCodeList04() {
    }

    @Nonnull
    public static CodeListDocument convertToSimpleCodeList(@Nonnull Sheet sheet, @Nonnull ExcelReadOptions<UseType> excelReadOptions, @Nonnull String string, @Nonnull String string2, @Nonnull URI uRI, @Nonnull URI uRI2, @Nullable URI uRI3) {
        Object object;
        String string3;
        ValueEnforcer.notNull((Object)sheet, (String)"ExcelSheet");
        ValueEnforcer.notNull(excelReadOptions, (String)"ReadOptions");
        ObjectFactory objectFactory = new ObjectFactory();
        CodeListDocument codeListDocument = objectFactory.createCodeListDocument();
        Annotation annotation = objectFactory.createAnnotation();
        AnyOtherContent anyOtherContent = objectFactory.createAnyOtherContent();
        anyOtherContent.addAny(new JAXBElement(QNAME_ANNOTATION, String.class, null, (Object)"Automatically created by ph-genericode. Do NOT edit."));
        annotation.setAppInfo(anyOtherContent);
        codeListDocument.setAnnotation(annotation);
        Identification identification = objectFactory.createIdentification();
        identification.setShortName(Genericode04Helper.createShortName(string));
        identification.setVersion(string2);
        identification.setCanonicalUri(uRI.toString());
        identification.setCanonicalVersionUri(uRI2.toString());
        if (uRI3 != null) {
            identification.addLocationUri(uRI3.toString());
        }
        codeListDocument.setIdentification(identification);
        ICommonsList<ExcelReadColumn<UseType>> iCommonsList = excelReadOptions.getAllColumns();
        ColumnSet columnSet = objectFactory.createColumnSet();
        for (ExcelReadColumn excelReadColumn : iCommonsList) {
            string3 = sheet.getRow(excelReadOptions.getLineIndexShortName()).getCell(excelReadColumn.getIndex()).getStringCellValue();
            object = null;
            if (excelReadOptions.getLineIndexLongName() >= 0) {
                object = sheet.getRow(excelReadOptions.getLineIndexLongName()).getCell(excelReadColumn.getIndex()).getStringCellValue();
            }
            Column column = Genericode04Helper.createColumn(excelReadColumn.getColumnID(), (UseType)((Object)excelReadColumn.getUseType()), string3, (String)object, excelReadColumn.getDataType());
            columnSet.addColumnChoice(column);
            if (!excelReadColumn.isKeyColumn()) continue;
            Serializable serializable = Genericode04Helper.createKey(excelReadColumn.getColumnID() + "Key", string3, (String)object, column);
            columnSet.addKeyChoice(serializable);
        }
        codeListDocument.setColumnSet(columnSet);
        SimpleCodeList simpleCodeList = objectFactory.createSimpleCodeList();
        int n = excelReadOptions.getLinesToSkip();
        while ((string3 = sheet.getRow(n++)) != null) {
            object = objectFactory.createRow();
            for (Serializable serializable : iCommonsList) {
                String string4 = ExcelReadHelper.getCellValueString((Cell)string3.getCell(serializable.getIndex()));
                if (!StringHelper.hasText((String)string4) && serializable.getUseType() != UseType.REQUIRED) continue;
                Value value = objectFactory.createValue();
                value.setColumnRef(Genericode04Helper.getColumnOfID(columnSet, serializable.getColumnID()));
                value.setSimpleValue(Genericode04Helper.createSimpleValue(string4));
                ((Row)object).addValue(value);
            }
            simpleCodeList.addRow((Row)object);
        }
        codeListDocument.setSimpleCodeList(simpleCodeList);
        return codeListDocument;
    }
}

