/*
 * Decompiled with CFR 0.152.
 */
package com.helger.genericode.v10;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.genericode.v10.Annotation;
import com.helger.genericode.v10.KeyColumnRef;
import com.helger.genericode.v10.LongName;
import com.helger.genericode.v10.ShortName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Key", propOrder={"annotation", "shortName", "longName", "canonicalUri", "canonicalVersionUri", "columnRef"})
@CodingStyleguideUnaware
public class Key
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="Annotation")
    private Annotation annotation;
    @XmlElement(name="ShortName", required=true)
    private ShortName shortName;
    @XmlElement(name="LongName")
    private List<LongName> longName;
    @XmlElement(name="CanonicalUri")
    @XmlSchemaType(name="anyURI")
    private String canonicalUri;
    @XmlElement(name="CanonicalVersionUri")
    @XmlSchemaType(name="anyURI")
    private String canonicalVersionUri;
    @XmlElement(name="ColumnRef", required=true)
    private List<KeyColumnRef> columnRef;
    @XmlAttribute(name="Id", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    private String id;

    @Nullable
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(@Nullable Annotation annotation) {
        this.annotation = annotation;
    }

    @Nullable
    public ShortName getShortName() {
        return this.shortName;
    }

    public void setShortName(@Nullable ShortName shortName) {
        this.shortName = shortName;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<LongName> getLongName() {
        if (this.longName == null) {
            this.longName = new ArrayList<LongName>();
        }
        return this.longName;
    }

    @Nullable
    public String getCanonicalUri() {
        return this.canonicalUri;
    }

    public void setCanonicalUri(@Nullable String string) {
        this.canonicalUri = string;
    }

    @Nullable
    public String getCanonicalVersionUri() {
        return this.canonicalVersionUri;
    }

    public void setCanonicalVersionUri(@Nullable String string) {
        this.canonicalVersionUri = string;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<KeyColumnRef> getColumnRef() {
        if (this.columnRef == null) {
            this.columnRef = new ArrayList<KeyColumnRef>();
        }
        return this.columnRef;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String string) {
        this.id = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Key key = (Key)object;
        if (!EqualsHelper.equals((Object)this.annotation, (Object)key.annotation)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.canonicalUri, (Object)key.canonicalUri)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.canonicalVersionUri, (Object)key.canonicalVersionUri)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.columnRef, key.columnRef)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.id, (Object)key.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.longName, key.longName)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.shortName, (Object)key.shortName);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.annotation).append((Object)this.canonicalUri).append((Object)this.canonicalVersionUri).append(this.columnRef).append((Object)this.id).append(this.longName).append((Object)this.shortName).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("annotation", (Object)this.annotation).append("canonicalUri", (Object)this.canonicalUri).append("canonicalVersionUri", (Object)this.canonicalVersionUri).append("columnRef", this.columnRef).append("id", (Object)this.id).append("longName", this.longName).append("shortName", (Object)this.shortName).getToString();
    }

    public void setLongName(@Nullable List<LongName> list) {
        this.longName = list;
    }

    public void setColumnRef(@Nullable List<KeyColumnRef> list) {
        this.columnRef = list;
    }

    public boolean hasLongNameEntries() {
        return !this.getLongName().isEmpty();
    }

    public boolean hasNoLongNameEntries() {
        return this.getLongName().isEmpty();
    }

    @Nonnegative
    public int getLongNameCount() {
        return this.getLongName().size();
    }

    @Nullable
    public LongName getLongNameAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getLongName().get(n);
    }

    public void addLongName(@Nonnull LongName longName) {
        this.getLongName().add(longName);
    }

    public boolean hasColumnRefEntries() {
        return !this.getColumnRef().isEmpty();
    }

    public boolean hasNoColumnRefEntries() {
        return this.getColumnRef().isEmpty();
    }

    @Nonnegative
    public int getColumnRefCount() {
        return this.getColumnRef().size();
    }

    @Nullable
    public KeyColumnRef getColumnRefAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getColumnRef().get(n);
    }

    public void addColumnRef(@Nonnull KeyColumnRef keyColumnRef) {
        this.getColumnRef().add(keyColumnRef);
    }

    public void cloneTo(@Nonnull Key key) {
        ArrayList<KeyColumnRef> arrayList;
        key.annotation = this.annotation == null ? null : this.annotation.clone();
        key.canonicalUri = this.canonicalUri;
        key.canonicalVersionUri = this.canonicalVersionUri;
        if (this.columnRef == null) {
            key.columnRef = null;
        } else {
            arrayList = new ArrayList<KeyColumnRef>();
            for (KeyColumnRef iExplicitlyCloneable : this.getColumnRef()) {
                arrayList.add(iExplicitlyCloneable == null ? null : iExplicitlyCloneable.clone());
            }
            key.columnRef = arrayList;
        }
        key.id = this.id;
        if (this.longName == null) {
            key.longName = null;
        } else {
            arrayList = new ArrayList();
            for (LongName longName : this.getLongName()) {
                arrayList.add((KeyColumnRef)((Object)(longName == null ? null : longName.clone())));
            }
            key.longName = arrayList;
        }
        key.shortName = this.shortName == null ? null : this.shortName.clone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Key clone() {
        Key key = new Key();
        this.cloneTo(key);
        return key;
    }

    @Nonnull
    public ShortName setShortName(@Nullable String string) {
        ShortName shortName = this.getShortName();
        if (shortName == null) {
            shortName = new ShortName(string);
            this.setShortName(shortName);
        } else {
            shortName.setValue(string);
        }
        return shortName;
    }

    @Nullable
    public String getShortNameValue() {
        ShortName shortName = this.getShortName();
        return shortName == null ? null : shortName.getValue();
    }
}

