/*
 * Decompiled with CFR 0.152.
 */
package com.helger.genericode.v10;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.genericode.v10.Annotation;
import com.helger.genericode.v10.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Row", propOrder={"annotation", "value"})
@CodingStyleguideUnaware
public class Row
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="Annotation")
    private Annotation annotation;
    @XmlElement(name="Value", required=true)
    private List<Value> value;

    public Row() {
    }

    public Row(@Nullable List<Value> list) {
        this.setValue(list);
    }

    @Nullable
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(@Nullable Annotation annotation) {
        this.annotation = annotation;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<Value> getValue() {
        if (this.value == null) {
            this.value = new ArrayList<Value>();
        }
        return this.value;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Row row = (Row)object;
        if (!EqualsHelper.equals((Object)this.annotation, (Object)row.annotation)) {
            return false;
        }
        return EqualsHelper.equalsCollection(this.value, row.value);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.annotation).append(this.value).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("annotation", (Object)this.annotation).append("value", this.value).getToString();
    }

    public void setValue(@Nullable List<Value> list) {
        this.value = list;
    }

    public boolean hasValueEntries() {
        return !this.getValue().isEmpty();
    }

    public boolean hasNoValueEntries() {
        return this.getValue().isEmpty();
    }

    @Nonnegative
    public int getValueCount() {
        return this.getValue().size();
    }

    @Nullable
    public Value getValueAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getValue().get(n);
    }

    public void addValue(@Nonnull Value value) {
        this.getValue().add(value);
    }

    public void cloneTo(@Nonnull Row row) {
        Annotation annotation = row.annotation = this.annotation == null ? null : this.annotation.clone();
        if (this.value == null) {
            row.value = null;
        } else {
            ArrayList<Value> arrayList = new ArrayList<Value>();
            for (Value value : this.getValue()) {
                arrayList.add(value == null ? null : value.clone());
            }
            row.value = arrayList;
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Row clone() {
        Row row = new Row();
        this.cloneTo(row);
        return row;
    }
}

