/*
 * Decompiled with CFR 0.152.
 */
package com.helger.genericode;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.StringHelper;
import com.helger.genericode.v04.Column;
import com.helger.genericode.v04.ColumnRef;
import com.helger.genericode.v04.ColumnSet;
import com.helger.genericode.v04.Data;
import com.helger.genericode.v04.Key;
import com.helger.genericode.v04.KeyColumnRef;
import com.helger.genericode.v04.LongName;
import com.helger.genericode.v04.Row;
import com.helger.genericode.v04.ShortName;
import com.helger.genericode.v04.SimpleValue;
import com.helger.genericode.v04.UseType;
import com.helger.genericode.v04.Value;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Genericode04Helper {
    private Genericode04Helper() {
    }

    @Nonnull
    public static String getColumnElementID(@Nonnull Object object) {
        if (object instanceof ColumnRef) {
            return ((ColumnRef)object).getId();
        }
        if (object instanceof Column) {
            return ((Column)object).getId();
        }
        if (object instanceof Key) {
            List<KeyColumnRef> list = ((Key)object).getColumnRef();
            KeyColumnRef keyColumnRef = (KeyColumnRef)CollectionHelper.getFirstElement(list);
            if (keyColumnRef == null) {
                throw new IllegalArgumentException("Key contains not KeyColumnRef!!");
            }
            Object object2 = keyColumnRef.getRef();
            if (object2 instanceof Column) {
                return ((Column)object2).getId();
            }
            throw new IllegalArgumentException("Unsupported referenced object: " + object2 + " - " + ClassHelper.getSafeClassName((Object)object2));
        }
        throw new IllegalArgumentException("Illegal column element: " + object + " - " + ClassHelper.getSafeClassName((Object)object));
    }

    @Nullable
    public static String getRowValue(@Nonnull Row row, @Nonnull String string) {
        for (Value value : row.getValue()) {
            String string2 = Genericode04Helper.getColumnElementID(value.getColumnRef());
            if (!string2.equals(string)) continue;
            SimpleValue simpleValue = value.getSimpleValue();
            return simpleValue != null ? simpleValue.getValue() : null;
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Column> getAllColumns(@Nonnull ColumnSet columnSet) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Genericode04Helper.getAllColumns(columnSet, (Collection<Column>)commonsArrayList);
        return commonsArrayList;
    }

    public static void getAllColumns(@Nonnull ColumnSet columnSet, @Nonnull Collection<Column> collection) {
        CollectionHelper.findAll(columnSet.getColumnChoice(), object -> object instanceof Column, object -> collection.add((Column)object));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllColumnIDs(@Nonnull ColumnSet columnSet) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Genericode04Helper.getAllColumnIDs(columnSet, (Collection<String>)commonsArrayList);
        return commonsArrayList;
    }

    public static void getAllColumnIDs(@Nonnull ColumnSet columnSet, @Nonnull Collection<String> collection) {
        CollectionHelper.findAll(columnSet.getColumnChoice(), object -> object instanceof Column, object -> collection.add(((Column)object).getId()));
    }

    @Nullable
    public static Column getColumnOfID(@Nonnull ColumnSet columnSet, @Nullable String string) {
        if (string != null) {
            for (Column column : Genericode04Helper.getAllColumns(columnSet)) {
                if (!column.getId().equals(string)) continue;
                return column;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Key> getAllKeys(@Nonnull ColumnSet columnSet) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Genericode04Helper.getAllKeys(columnSet, (Collection<Key>)commonsArrayList);
        return commonsArrayList;
    }

    public static void getAllKeys(@Nonnull ColumnSet columnSet, @Nonnull Collection<Key> collection) {
        CollectionHelper.findAll(columnSet.getKeyChoice(), object -> object instanceof Key, object -> collection.add((Key)object));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllKeyIDs(@Nonnull ColumnSet columnSet) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Genericode04Helper.getAllKeyIDs(columnSet, (Collection<String>)commonsArrayList);
        return commonsArrayList;
    }

    public static void getAllKeyIDs(@Nonnull ColumnSet columnSet, @Nonnull Collection<String> collection) {
        CollectionHelper.findAll(columnSet.getKeyChoice(), object -> object instanceof Key, object -> collection.add(((Key)object).getId()));
    }

    @Nullable
    public static Key getKeyOfID(@Nonnull ColumnSet columnSet, @Nullable String string) {
        if (string != null) {
            for (Key key : Genericode04Helper.getAllKeys(columnSet)) {
                if (!key.getId().equals(string)) continue;
                return key;
            }
        }
        return null;
    }

    public static boolean isKeyColumn(@Nonnull ColumnSet columnSet, @Nullable String string) {
        if (string != null) {
            for (Key key : Genericode04Helper.getAllKeys(columnSet)) {
                for (KeyColumnRef keyColumnRef : key.getColumnRef()) {
                    if (!(keyColumnRef.getRef() instanceof Column) || !((Column)keyColumnRef.getRef()).getId().equals(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nonnull
    public static ShortName createShortName(@Nullable String string) {
        ShortName shortName = new ShortName();
        shortName.setValue(string);
        return shortName;
    }

    @Nonnull
    public static LongName createLongName(@Nullable String string) {
        LongName longName = new LongName();
        longName.setValue(string);
        return longName;
    }

    @Nonnull
    public static SimpleValue createSimpleValue(@Nullable String string) {
        SimpleValue simpleValue = new SimpleValue();
        simpleValue.setValue(string);
        return simpleValue;
    }

    @Nonnull
    public static KeyColumnRef createKeyColumnRef(@Nullable Column column) {
        KeyColumnRef keyColumnRef = new KeyColumnRef();
        keyColumnRef.setRef(column);
        return keyColumnRef;
    }

    @Nonnull
    public static Column createColumn(@Nonnull @Nonempty String string, @Nonnull UseType useType, @Nonnull @Nonempty String string2, @Nullable String string3, @Nonnull @Nonempty String string4) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ColumnID");
        ValueEnforcer.notNull((Object)((Object)useType), (String)"useType");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"ShortName");
        ValueEnforcer.notEmpty((CharSequence)string4, (String)"DataType");
        Column column = new Column();
        column.setId(string);
        column.setUse(useType);
        column.setShortName(Genericode04Helper.createShortName(string2));
        if (StringHelper.hasText((String)string3)) {
            column.getLongName().add(Genericode04Helper.createLongName(string3));
        }
        Data data = new Data();
        data.setType(string4);
        column.setData(data);
        return column;
    }

    @Nonnull
    public static Key createKey(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nonnull Column column) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ColumnID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"ShortName");
        ValueEnforcer.notNull((Object)column, (String)"Column");
        Key key = new Key();
        key.setId(string);
        key.setShortName(Genericode04Helper.createShortName(string2));
        if (StringHelper.hasText((String)string3)) {
            key.getLongName().add(Genericode04Helper.createLongName(string3));
        }
        key.getColumnRef().add(Genericode04Helper.createKeyColumnRef(column));
        return key;
    }
}

