/*
 * Decompiled with CFR 0.152.
 */
package com.helger.genericode.excel;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExcelReadColumn<USE_TYPE extends Serializable>
implements Serializable {
    private final int m_nIndex;
    private final String m_sColumnID;
    private final USE_TYPE m_eUseType;
    private final String m_sDataType;
    private final boolean m_bKeyColumn;

    public ExcelReadColumn(@Nonnegative int n, @Nonnull @Nonempty String string, @Nonnull USE_TYPE USE_TYPE, @Nonnull @Nonempty String string2, boolean bl) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ColumnID");
        ValueEnforcer.notNull(USE_TYPE, (String)"UseType");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"DataType");
        this.m_nIndex = n;
        this.m_sColumnID = string;
        this.m_eUseType = USE_TYPE;
        this.m_sDataType = string2;
        this.m_bKeyColumn = bl;
    }

    @Nonnegative
    public int getIndex() {
        return this.m_nIndex;
    }

    @Nonnull
    @Nonempty
    public String getColumnID() {
        return this.m_sColumnID;
    }

    @Nonnull
    public USE_TYPE getUseType() {
        return this.m_eUseType;
    }

    @Nonnull
    @Nonempty
    public String getDataType() {
        return this.m_sDataType;
    }

    public boolean isKeyColumn() {
        return this.m_bKeyColumn;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("index", this.m_nIndex).append("columnID", (Object)this.m_sColumnID).append("use", this.m_eUseType).append("dataType", (Object)this.m_sDataType).append("keyColumn", this.m_bKeyColumn).getToString();
    }
}

