/*
 * Decompiled with CFR 0.152.
 */
package com.helger.genericode.excel;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.genericode.excel.ExcelReadColumn;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ExcelReadOptions<USE_TYPE extends Serializable>
implements Serializable {
    public static final int DEFAULT_LINES_TO_SKIP = 0;
    public static final int DEFAULT_LINEINDEX_SHORTNAME = 0;
    public static final int DEFAULT_LINEINDEX_LONGNAME = -1;
    private int m_nLinesToSkip = 0;
    private int m_nLineIndexShortName = 0;
    private int m_nLineIndexLongName = -1;
    private final ICommonsMap<Integer, ExcelReadColumn<USE_TYPE>> m_aColumns = new CommonsTreeMap();

    @Nonnull
    public ExcelReadOptions<USE_TYPE> setLinesToSkip(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"LinesToSkip");
        this.m_nLinesToSkip = n;
        return this;
    }

    @Nonnegative
    public int getLinesToSkip() {
        return this.m_nLinesToSkip;
    }

    @Nonnull
    public ExcelReadOptions<USE_TYPE> setLineIndexShortName(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"LineIndexShortName");
        this.m_nLineIndexShortName = n;
        return this;
    }

    @Nonnegative
    public int getLineIndexShortName() {
        return this.m_nLineIndexShortName;
    }

    @Nonnull
    public ExcelReadOptions<USE_TYPE> setLineIndexLongName(int n) {
        this.m_nLineIndexLongName = n;
        return this;
    }

    public int getLineIndexLongName() {
        return this.m_nLineIndexLongName;
    }

    @Nonnull
    public ExcelReadOptions<USE_TYPE> addColumn(@Nonnegative int n, @Nonnull @Nonempty String string, @Nonnull USE_TYPE USE_TYPE, @Nonnull @Nonempty String string2, boolean bl) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        Integer n2 = n;
        if (this.m_aColumns.containsKey((Object)n2)) {
            throw new IllegalArgumentException("The column at index " + n + " is already mapped!");
        }
        this.m_aColumns.put((Object)n2, new ExcelReadColumn<USE_TYPE>(n, string, USE_TYPE, string2, bl));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ExcelReadColumn<USE_TYPE>> getAllColumns() {
        return this.m_aColumns.copyOfValues();
    }
}

