/*
 * Decompiled with CFR 0.152.
 */
package com.helger.genericode.v04;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.genericode.v04.Annotation;
import com.helger.genericode.v04.InputCodeList;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CodeListUnion", propOrder={"annotation", "source"})
@CodingStyleguideUnaware
public class CodeListUnion
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="Annotation")
    private Annotation annotation;
    @XmlElement(name="Source", required=true)
    private List<InputCodeList> source;

    @Nullable
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(@Nullable Annotation annotation) {
        this.annotation = annotation;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<InputCodeList> getSource() {
        if (this.source == null) {
            this.source = new ArrayList<InputCodeList>();
        }
        return this.source;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CodeListUnion codeListUnion = (CodeListUnion)object;
        if (!EqualsHelper.equals((Object)this.annotation, (Object)codeListUnion.annotation)) {
            return false;
        }
        return EqualsHelper.equalsCollection(this.source, codeListUnion.source);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.annotation).append(this.source).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("annotation", (Object)this.annotation).append("source", this.source).getToString();
    }

    public void setSource(@Nullable List<InputCodeList> list) {
        this.source = list;
    }

    public boolean hasSourceEntries() {
        return !this.getSource().isEmpty();
    }

    public boolean hasNoSourceEntries() {
        return this.getSource().isEmpty();
    }

    @Nonnegative
    public int getSourceCount() {
        return this.getSource().size();
    }

    @Nullable
    public InputCodeList getSourceAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getSource().get(n);
    }

    public void addSource(@Nonnull InputCodeList inputCodeList) {
        this.getSource().add(inputCodeList);
    }

    public void cloneTo(@Nonnull CodeListUnion codeListUnion) {
        Annotation annotation = codeListUnion.annotation = this.annotation == null ? null : this.annotation.clone();
        if (this.source == null) {
            codeListUnion.source = null;
        } else {
            ArrayList<InputCodeList> arrayList = new ArrayList<InputCodeList>();
            for (InputCodeList inputCodeList : this.getSource()) {
                arrayList.add(inputCodeList == null ? null : inputCodeList.clone());
            }
            codeListUnion.source = arrayList;
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public CodeListUnion clone() {
        CodeListUnion codeListUnion = new CodeListUnion();
        this.cloneTo(codeListUnion);
        return codeListUnion;
    }
}

