/*
 * Decompiled with CFR 0.152.
 */
package com.helger.genericode.v04;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.genericode.v04.Annotation;
import com.helger.genericode.v04.DatatypeFacet;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Data", propOrder={"annotation", "parameter"})
@CodingStyleguideUnaware
public class Data
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="Annotation")
    private Annotation annotation;
    @XmlElement(name="Parameter")
    private List<DatatypeFacet> parameter;
    @XmlAttribute(name="Type", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="token")
    private String type;
    @XmlAttribute(name="DatatypeLibrary")
    @XmlSchemaType(name="anyURI")
    private String datatypeLibrary;
    @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace")
    private String lang;

    @Nullable
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(@Nullable Annotation annotation) {
        this.annotation = annotation;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<DatatypeFacet> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<DatatypeFacet>();
        }
        return this.parameter;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String string) {
        this.type = string;
    }

    @Nullable
    public String getDatatypeLibrary() {
        return this.datatypeLibrary;
    }

    public void setDatatypeLibrary(@Nullable String string) {
        this.datatypeLibrary = string;
    }

    @Nullable
    public String getLang() {
        return this.lang;
    }

    public void setLang(@Nullable String string) {
        this.lang = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Data data = (Data)object;
        if (!EqualsHelper.equals((Object)this.annotation, (Object)data.annotation)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.datatypeLibrary, (Object)data.datatypeLibrary)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.lang, (Object)data.lang)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.parameter, data.parameter)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.type, (Object)data.type);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.annotation).append((Object)this.datatypeLibrary).append((Object)this.lang).append(this.parameter).append((Object)this.type).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("annotation", (Object)this.annotation).append("datatypeLibrary", (Object)this.datatypeLibrary).append("lang", (Object)this.lang).append("parameter", this.parameter).append("type", (Object)this.type).getToString();
    }

    public void setParameter(@Nullable List<DatatypeFacet> list) {
        this.parameter = list;
    }

    public boolean hasParameterEntries() {
        return !this.getParameter().isEmpty();
    }

    public boolean hasNoParameterEntries() {
        return this.getParameter().isEmpty();
    }

    @Nonnegative
    public int getParameterCount() {
        return this.getParameter().size();
    }

    @Nullable
    public DatatypeFacet getParameterAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getParameter().get(n);
    }

    public void addParameter(@Nonnull DatatypeFacet datatypeFacet) {
        this.getParameter().add(datatypeFacet);
    }

    public void cloneTo(@Nonnull Data data) {
        data.annotation = this.annotation == null ? null : this.annotation.clone();
        data.datatypeLibrary = this.datatypeLibrary;
        data.lang = this.lang;
        if (this.parameter == null) {
            data.parameter = null;
        } else {
            ArrayList<DatatypeFacet> arrayList = new ArrayList<DatatypeFacet>();
            for (DatatypeFacet datatypeFacet : this.getParameter()) {
                arrayList.add(datatypeFacet == null ? null : datatypeFacet.clone());
            }
            data.parameter = arrayList;
        }
        data.type = this.type;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Data clone() {
        Data data = new Data();
        this.cloneTo(data);
        return data;
    }
}

