/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.helper.CollectionSort;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlugin
extends Plugin {
    private final Logger m_aLogger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean m_bDebugMode;

    protected AbstractPlugin() {
    }

    protected final void initPluginLogging(boolean bl) {
        this.m_bDebugMode = bl;
    }

    protected final void logDebug(@NonNull Supplier<String> supplier) {
        if (this.m_bDebugMode) {
            this.logInfo(supplier.get());
        }
    }

    protected final void logInfo(String string) {
        this.m_aLogger.info(string);
    }

    protected final void logWarn(String string) {
        this.m_aLogger.warn(string);
    }

    protected final void logError(String string) {
        this.m_aLogger.error(string);
    }

    protected final void logError(String string, @Nullable Exception exception) {
        this.m_aLogger.error(string, (Throwable)exception);
    }

    @CodingStyleguideUnaware
    public List<String> getCustomizationURIs() {
        return CollectionHelper.makeUnmodifiable((Object[])new String[]{"http://www.helger.com/namespaces/jaxb/plugin"});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ReturnsMutableCopy
    protected @NonNull ICommonsOrderedMap<JFieldVar, String> getAllInstanceFields(@NonNull ClassOutline classOutline) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        JDefinedClass jDefinedClass = classOutline.implClass;
        for (JFieldVar jFieldVar : CollectionSort.getSortedByKey((Map)jDefinedClass.fields()).values()) {
            String string;
            String string2 = jFieldVar.name();
            if ((jFieldVar.mods().getValue() & 0x10) == 16) {
                this.logDebug(() -> "Ignoring static field '" + string2 + "'");
                continue;
            }
            CPropertyInfo cPropertyInfo2 = classOutline.target.getProperty(string2);
            if (cPropertyInfo2 == null) {
                if (!"otherAttributes".equals(string2)) throw new IllegalStateException("'" + jFieldVar.name() + "' not found in " + String.valueOf(new CommonsArrayList((Collection)classOutline.target.getProperties(), cPropertyInfo -> cPropertyInfo.getName(false))) + " of " + jDefinedClass.fullName());
                string = string2;
            } else {
                string = cPropertyInfo2.getName(true);
            }
            commonsLinkedHashMap.put((Object)jFieldVar, (Object)string);
        }
        return commonsLinkedHashMap;
    }
}

