/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.base.numeric.BigHelper;
import com.helger.base.string.StringParser;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.impl.AttributeUseImpl;
import com.sun.xml.xsom.impl.ElementDecl;
import com.sun.xml.xsom.impl.RestrictionSimpleTypeImpl;
import com.sun.xml.xsom.impl.parser.DelayedRef;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.xml.sax.ErrorHandler;

public abstract class AbstractPluginBeanValidation
extends AbstractPlugin {
    private static final BigInteger UNBOUNDED = BigInteger.valueOf(-1L);
    private static final String[] NUMBER_TYPES = new String[]{"BigDecimal", "BigInteger", "String", "byte", "short", "int", "long"};
    private final boolean m_bJSR349;

    protected AbstractPluginBeanValidation(boolean bl) {
        this.m_bJSR349 = !bl;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        try {
            for (ClassOutline classOutline : outline.getClasses()) {
                List list = classOutline.target.getProperties();
                for (CPropertyInfo cPropertyInfo : list) {
                    if (cPropertyInfo instanceof CElementPropertyInfo) {
                        this._processElementProperty((CElementPropertyInfo)cPropertyInfo, classOutline);
                        continue;
                    }
                    if (cPropertyInfo instanceof CAttributePropertyInfo) {
                        this._processAttributeProperty((CAttributePropertyInfo)cPropertyInfo, classOutline);
                        continue;
                    }
                    if (cPropertyInfo instanceof CValuePropertyInfo) {
                        this._processValueProperty((CValuePropertyInfo)cPropertyInfo, classOutline);
                        continue;
                    }
                    if (cPropertyInfo instanceof CReferencePropertyInfo) continue;
                    this.logWarn("Unsupported property: " + String.valueOf(cPropertyInfo));
                }
            }
            return true;
        }
        catch (Exception exception) {
            this.logError("Internal error creating bean validation", exception);
            return false;
        }
    }

    private void _processElementProperty(@NonNull CElementPropertyInfo cElementPropertyInfo, @NonNull ClassOutline classOutline) {
        XSTerm xSTerm;
        XSParticle xSParticle = (XSParticle)cElementPropertyInfo.getSchemaComponent();
        JCodeModel jCodeModel = classOutline.implClass.owner();
        BigInteger bigInteger = xSParticle.getMinOccurs();
        BigInteger bigInteger2 = xSParticle.getMaxOccurs();
        JFieldVar jFieldVar = (JFieldVar)classOutline.implClass.fields().get(cElementPropertyInfo.getName(false));
        boolean bl = cElementPropertyInfo.isRequired();
        if ((BigHelper.isLT0((BigInteger)bigInteger) || BigHelper.isGE1((BigInteger)bigInteger) && bl) && !AbstractPluginBeanValidation._hasAnnotation(jFieldVar, NotNull.class)) {
            jFieldVar.annotate(NotNull.class);
        }
        if (bigInteger2.compareTo(BigInteger.ONE) > 0 && !AbstractPluginBeanValidation._hasAnnotation(jFieldVar, Size.class)) {
            jFieldVar.annotate(Size.class).param("min", bigInteger.intValue()).param("max", bigInteger2.intValue());
        }
        if (UNBOUNDED.equals(bigInteger2) && BigHelper.isGT0((BigInteger)bigInteger) && !AbstractPluginBeanValidation._hasAnnotation(jFieldVar, Size.class)) {
            jFieldVar.annotate(Size.class).param("min", bigInteger.intValue());
        }
        String string = jFieldVar.type().erasure().fullName();
        if ((jFieldVar.type().isArray() || string.equals("java.util.Collection") || string.equals("java.util.Set") || string.equals("java.util.List") || string.equals("java.util.Map") || jFieldVar.type() instanceof JDefinedClass) && !AbstractPluginBeanValidation._hasAnnotation(jFieldVar, Valid.class)) {
            jFieldVar.annotate(Valid.class);
        }
        if ((xSTerm = xSParticle.getTerm()) instanceof ElementDecl) {
            this._processElement(jFieldVar, (ElementDecl)xSTerm);
        } else if (xSTerm instanceof DelayedRef.Element) {
            XSElementDecl xSElementDecl = ((DelayedRef.Element)xSTerm).get();
            this._processElement(jFieldVar, (ElementDecl)xSElementDecl);
        } else if (!(xSTerm instanceof XSModelGroup)) {
            this.logWarn("Unsupported particle term '" + String.valueOf(xSTerm) + "'");
        }
    }

    private void _processElement(@NonNull JFieldVar jFieldVar, ElementDecl elementDecl) {
        XSType xSType = elementDecl.getType();
        if (xSType instanceof XSSimpleType) {
            this._processType((XSSimpleType)xSType, jFieldVar);
        } else if (xSType.getBaseType() instanceof XSSimpleType) {
            this._processType((XSSimpleType)xSType.getBaseType(), jFieldVar);
        }
    }

    private boolean _isSizeAnnotationApplicable(@NonNull JFieldVar jFieldVar) {
        return jFieldVar.type().name().equals("String") || jFieldVar.type().isArray();
    }

    private void _processType(XSSimpleType xSSimpleType, @NonNull JFieldVar jFieldVar) {
        JAnnotationUse jAnnotationUse;
        Integer n;
        Integer n2;
        XSFacet xSFacet;
        String string;
        XSFacet xSFacet2;
        if (!AbstractPluginBeanValidation._hasAnnotation(jFieldVar, Size.class) && this._isSizeAnnotationApplicable(jFieldVar)) {
            xSFacet2 = xSSimpleType.getFacet("maxLength");
            string = xSFacet2 == null ? null : StringParser.parseIntObj((String)xSFacet2.getValue().value);
            xSFacet = xSSimpleType.getFacet("minLength");
            Integer n3 = n2 = xSFacet == null ? null : StringParser.parseIntObj((String)xSFacet.getValue().value);
            if (n2 != null) {
                if (string != null) {
                    jFieldVar.annotate(Size.class).param("min", n2.intValue()).param("max", ((Integer)((Object)string)).intValue());
                } else {
                    jFieldVar.annotate(Size.class).param("min", n2.intValue());
                }
            } else if (string != null) {
                jFieldVar.annotate(Size.class).param("max", ((Integer)((Object)string)).intValue());
            }
        }
        if ((xSFacet2 = xSSimpleType.getFacet("pattern")) != null && !"\\c+".equals(string = xSFacet2.getValue().value) && !AbstractPluginBeanValidation._hasAnnotation(jFieldVar, Pattern.class)) {
            jFieldVar.annotate(Pattern.class).param("regexp", string);
        }
        if (AbstractPluginBeanValidation._isNumericType(jFieldVar)) {
            string = xSSimpleType.getFacet("maxInclusive");
            if (string != null && AbstractPluginBeanValidation._isValidMinMaxValue((XSFacet)string) && !AbstractPluginBeanValidation._hasAnnotation(jFieldVar, DecimalMax.class)) {
                jFieldVar.annotate(DecimalMax.class).param("value", string.getValue().value);
            }
            if ((xSFacet = xSSimpleType.getFacet("minInclusive")) != null && AbstractPluginBeanValidation._isValidMinMaxValue(xSFacet) && !AbstractPluginBeanValidation._hasAnnotation(jFieldVar, DecimalMin.class)) {
                jFieldVar.annotate(DecimalMin.class).param("value", xSFacet.getValue().value);
            }
            if ((n2 = xSSimpleType.getFacet("maxExclusive")) != null && AbstractPluginBeanValidation._isValidMinMaxValue((XSFacet)n2) && !AbstractPluginBeanValidation._hasAnnotation(jFieldVar, DecimalMax.class)) {
                n = jFieldVar.annotate(DecimalMax.class);
                n.param("value", n2.getValue().value);
                if (this.m_bJSR349) {
                    n.param("inclusive", false);
                }
            }
            if ((n = xSSimpleType.getFacet("minExclusive")) != null && AbstractPluginBeanValidation._isValidMinMaxValue((XSFacet)n) && !AbstractPluginBeanValidation._hasAnnotation(jFieldVar, DecimalMin.class)) {
                jAnnotationUse = jFieldVar.annotate(DecimalMin.class);
                jAnnotationUse.param("value", n.getValue().value);
                if (this.m_bJSR349) {
                    jAnnotationUse.param("inclusive", false);
                }
            }
        }
        string = xSSimpleType.getFacet("totalDigits");
        xSFacet = xSSimpleType.getFacet("fractionDigits");
        n2 = string == null ? null : StringParser.parseIntObj((String)string.getValue().value);
        Integer n4 = n = xSFacet == null ? null : StringParser.parseIntObj((String)xSFacet.getValue().value);
        if (!AbstractPluginBeanValidation._hasAnnotation(jFieldVar, Digits.class) && n2 != null) {
            jAnnotationUse = jFieldVar.annotate(Digits.class);
            if (n == null) {
                jAnnotationUse.param("integer", n2.intValue());
            } else {
                jAnnotationUse.param("integer", n2 - n);
                jAnnotationUse.param("fraction", n.intValue());
            }
        }
    }

    private void _processValueProperty(@NonNull CValuePropertyInfo cValuePropertyInfo, ClassOutline classOutline) {
        String string = cValuePropertyInfo.getName(false);
        XSComponent xSComponent = cValuePropertyInfo.getSchemaComponent();
        if (xSComponent instanceof RestrictionSimpleTypeImpl) {
            RestrictionSimpleTypeImpl restrictionSimpleTypeImpl = (RestrictionSimpleTypeImpl)xSComponent;
            XSSimpleType xSSimpleType = restrictionSimpleTypeImpl.asSimpleType();
            JFieldVar jFieldVar = (JFieldVar)classOutline.implClass.fields().get(string);
            this._processType(xSSimpleType, jFieldVar);
        }
    }

    private void _processAttributeProperty(CAttributePropertyInfo cAttributePropertyInfo, ClassOutline classOutline) {
        String string = cAttributePropertyInfo.getName(false);
        XSComponent xSComponent = cAttributePropertyInfo.getSchemaComponent();
        AttributeUseImpl attributeUseImpl = (AttributeUseImpl)xSComponent;
        XSSimpleType xSSimpleType = attributeUseImpl.getDecl().getType();
        JFieldVar jFieldVar = (JFieldVar)classOutline.implClass.fields().get(string);
        if (attributeUseImpl.isRequired() && !AbstractPluginBeanValidation._hasAnnotation(jFieldVar, NotNull.class)) {
            jFieldVar.annotate(NotNull.class);
        }
        this._processType(xSSimpleType, jFieldVar);
    }

    private static boolean _isEqualStr(long l, @Nullable String string) {
        return Long.toString(l).equals(string);
    }

    private static boolean _isValidMinMaxValue(@NonNull XSFacet xSFacet) {
        String string = xSFacet.getValue().value;
        return string != null && !AbstractPluginBeanValidation._isEqualStr(Long.MAX_VALUE, string) && !AbstractPluginBeanValidation._isEqualStr(Integer.MAX_VALUE, string) && !AbstractPluginBeanValidation._isEqualStr(Long.MIN_VALUE, string) && !AbstractPluginBeanValidation._isEqualStr(Integer.MIN_VALUE, string);
    }

    private static boolean _hasAnnotation(@NonNull JFieldVar jFieldVar, @NonNull Class<?> clazz) {
        Collection collection = jFieldVar.annotations();
        if (collection != null) {
            String string = clazz.getCanonicalName();
            for (JAnnotationUse jAnnotationUse : collection) {
                if (!jAnnotationUse.getAnnotationClass().fullName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean _isNumericType(@NonNull JFieldVar jFieldVar) {
        JType jType = jFieldVar.type();
        for (String string : NUMBER_TYPES) {
            if (!string.equalsIgnoreCase(jType.name())) continue;
            return true;
        }
        try {
            Class<?> exception = Class.forName(jType.fullName());
            return exception != null && Number.class.isAssignableFrom(exception);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

