/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.base.array.ArrayHelper;
import com.helger.jaxb.adapter.JAXBHelper;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;

public abstract class AbstractPluginCloneable
extends AbstractPlugin {
    private static final Map<String, Boolean> ENUM_CACHE = new HashMap<String, Boolean>();

    private boolean _loadClassAndCheckIfEnum(String string) {
        try {
            this.logDebug(() -> "Trying to load class '" + string + "'");
            Class<?> clazz = Class.forName(string);
            if (Enum.class.isAssignableFrom(clazz)) {
                this.logDebug(() -> "Class '" + string + "' was loaded and is an enum");
                return true;
            }
            this.logDebug(() -> "Class '" + string + "' was loaded and is NOT an enum");
        }
        catch (Throwable throwable) {
            this.logDebug(() -> "Class '" + string + "' was not loaded and is therefore NOT an enum");
        }
        return false;
    }

    protected boolean _isImmutable(@NonNull JType jType) {
        Boolean bl;
        Object object;
        if (jType.isPrimitive()) {
            return true;
        }
        if (jType instanceof JDefinedClass && (object = (JDefinedClass)jType).getClassType() == ClassType.ENUM) {
            return true;
        }
        if (jType instanceof JClass && (bl = ENUM_CACHE.computeIfAbsent((object = (JClass)jType).binaryName(), string -> this._loadClassAndCheckIfEnum((String)string))).booleanValue()) {
            return true;
        }
        object = jType.name();
        return ((String)object).equals("BigDecimal") || ((String)object).equals("BigInteger") || ((String)object).equals("Boolean") || ((String)object).equals("Byte") || ((String)object).equals("Character") || ((String)object).equals("DataHandler") || ((String)object).equals("Double") || ((String)object).equals("Duration") || ((String)object).equals("Element") || ((String)object).equals("Float") || ((String)object).equals("Integer") || ((String)object).equals("LocalDate") || ((String)object).equals("LocalDateTime") || ((String)object).equals("LocalTime") || ((String)object).equals("Long") || ((String)object).equals("Object") || ((String)object).equals("OffsetDate") || ((String)object).equals("OffsetDateTime") || ((String)object).equals("OffsetTime") || ((String)object).equals("Period") || ((String)object).equals("PeriodDuration") || ((String)object).equals("QName") || ((String)object).equals("Serializable") || ((String)object).equals("Short") || ((String)object).equals("String") || ((String)object).equals("W3CEndpointReference") || ((String)object).equals("XMLOffsetDate") || ((String)object).equals("XMLOffsetDateTime") || ((String)object).equals("XMLOffsetTime") || ((String)object).equals("ZonedDateTime");
    }

    protected static boolean _isJavaCloneable(@NonNull JType jType) {
        String string = jType.name();
        return string.equals("XMLGregorianCalendar");
    }

    protected boolean _isImmutableArray(@NonNull JType jType) {
        return jType.isArray() && this._isImmutable(jType.elementType());
    }

    protected @NonNull JExpression _getCloneCode(JCodeModel jCodeModel, JExpression jExpression, JType jType) {
        if (this._isImmutable(jType)) {
            return jExpression;
        }
        if (this._isImmutableArray(jType)) {
            return jCodeModel.ref(ArrayHelper.class).staticInvoke("getCopy").arg(jExpression);
        }
        if (AbstractPluginCloneable._isJavaCloneable(jType)) {
            return JOp.cond((JExpression)jExpression.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)JExpr.cast((JType)jType, (JExpression)jExpression.invoke("clone")));
        }
        if (jType.erasure().name().equals("JAXBElement")) {
            return jCodeModel.ref(JAXBHelper.class).staticInvoke("getClonedJAXBElement").arg(jExpression);
        }
        return JOp.cond((JExpression)jExpression.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)jExpression.invoke("clone"));
    }
}

