/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginAnnotate
extends AbstractPlugin {
    public static final String OPT = "Xph-annotate";

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-annotate :  add @jakarta.annotation.Nullable/@jakarta.annotation.NonNull annotations to getters and setters";
    }

    public boolean run(@NonNull Outline outline, @NonNull Options options, @NonNull ErrorHandler errorHandler) {
        List list;
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        JCodeModel jCodeModel = outline.getCodeModel();
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        for (Object object : outline.getClasses()) {
            JDefinedClass jDefinedClass = ((ClassOutline)object).implClass;
            for (JMethod jMethod : jDefinedClass.methods()) {
                JType jType;
                list = jMethod.params();
                if (jMethod.name().startsWith("get") && list.isEmpty()) {
                    jType = jMethod.type();
                    if (jType.erasure().name().equals("List")) {
                        jMethod.annotate(NonNull.class);
                        jMethod.annotate(ReturnsMutableObject.class).param("value", "JAXB implementation style");
                        commonsHashSet.add((Object)jDefinedClass);
                        continue;
                    }
                    if (jType.isPrimitive()) continue;
                    jMethod.annotate(Nullable.class);
                    commonsHashSet.add((Object)jDefinedClass);
                    continue;
                }
                if (jMethod.type() != jCodeModel.VOID || !jMethod.name().startsWith("set") || list.size() != 1 || (jType = (JVar)list.get(0)).type().isPrimitive()) continue;
                jType.annotate(Nullable.class);
                commonsHashSet.add((Object)jDefinedClass);
            }
        }
        CommonsHashSet commonsHashSet2 = new CommonsHashSet();
        for (JDefinedClass jDefinedClass : outline.getModel().getAllElements()) {
            JDefinedClass jDefinedClass2 = outline.getPackageContext(jDefinedClass._package()).objectFactoryGenerator().getObjectFactory();
            commonsHashSet2.add((Object)jDefinedClass2);
        }
        for (JDefinedClass jDefinedClass : commonsHashSet2) {
            for (JMethod jMethod : jDefinedClass.methods()) {
                list = jMethod.params();
                if (jMethod.name().startsWith("create") && jMethod.type().erasure().name().equals("JAXBElement") && list.size() == 1) {
                    ((JVar)list.get(0)).annotate(Nullable.class);
                    jMethod.annotate(NonNull.class);
                    commonsHashSet.add((Object)jDefinedClass);
                    continue;
                }
                if (!jMethod.name().startsWith("create") || !list.isEmpty()) continue;
                jMethod.annotate(NonNull.class);
                commonsHashSet.add((Object)jDefinedClass);
            }
        }
        for (JDefinedClass jDefinedClass : commonsHashSet) {
            jDefinedClass.javadoc().add((Object)"<p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>\n");
        }
        return true;
    }
}

