/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginCodeQuality
extends AbstractPlugin {
    public static final String OPT = "Xph-code-quality";

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-code-quality  fix some issues that cause warnings in the generated code";
    }

    public boolean run(@NonNull Outline outline, @NonNull Options options, @NonNull ErrorHandler errorHandler) {
        Object object2;
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        for (Object object2 : outline.getClasses()) {
            Object object3 = ((ClassOutline)object2).implClass;
        }
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        for (Object object3 : outline.getModel().getAllElements()) {
            JDefinedClass jDefinedClass = outline.getPackageContext(object3._package()).objectFactoryGenerator().getObjectFactory();
            commonsHashSet.add((Object)jDefinedClass);
        }
        object2 = outline.getCodeModel().BYTE.array().name();
        for (JDefinedClass jDefinedClass : commonsHashSet) {
            for (JFieldVar jFieldVar : jDefinedClass.fields().values()) {
                if (!jFieldVar.type().name().equals("QName")) continue;
                jFieldVar.mods().setPublic();
            }
            for (JFieldVar jFieldVar : jDefinedClass.methods()) {
                List list = jFieldVar.params();
                if (jFieldVar.name().startsWith("create") && jFieldVar.type().erasure().name().equals("JAXBElement") && list.size() == 1) {
                    JVar jVar = (JVar)list.get(0);
                    jVar.mods().setFinal(true);
                    jFieldVar.javadoc().addReturn().add((Object)"The created JAXBElement and never <code>null</code>.");
                    continue;
                }
                if (!jFieldVar.name().startsWith("create") || !list.isEmpty()) continue;
                jFieldVar.javadoc().addReturn().add((Object)("The created " + jFieldVar.type().name() + " object and never <code>null</code>."));
            }
        }
        return true;
    }
}

