/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.Outline;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginCodingStyleguideUnaware
extends AbstractPlugin {
    public static final String OPT = "Xph-csu";

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-csu       :  add @CodingStyleguideUnaware annotations to all classes";
    }

    private static void _apply(@NonNull JDefinedClass jDefinedClass) {
        jDefinedClass.annotate(CodingStyleguideUnaware.class);
        for (JClass jClass : jDefinedClass.listClasses()) {
            if (!(jClass instanceof JDefinedClass)) continue;
            PluginCodingStyleguideUnaware._apply((JDefinedClass)jClass);
        }
    }

    public boolean run(@NonNull Outline outline, @NonNull Options options, @NonNull ErrorHandler errorHandler) {
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        JCodeModel jCodeModel = outline.getCodeModel();
        Iterator iterator = jCodeModel.packages();
        while (iterator.hasNext()) {
            JPackage jPackage = (JPackage)iterator.next();
            Iterator iterator2 = jPackage.classes();
            while (iterator2.hasNext()) {
                JDefinedClass jDefinedClass = (JDefinedClass)iterator2.next();
                PluginCodingStyleguideUnaware._apply(jDefinedClass);
            }
        }
        return true;
    }
}

