/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.base.string.StringHelper;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.helger.text.locale.LocaleCache;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.Outline;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginDefaultLocale
extends AbstractPlugin {
    public static final String OPT = "Xph-default-locale";

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-default-locale locale   :  set Java default locale to the specified parameter. Use e.g. 'en_US'";
    }

    public int parseArgument(Options options, String[] stringArray, int n) throws BadCommandLineException {
        if (stringArray[n].equals("-Xph-default-locale")) {
            String string = options.requireArgument("-Xph-default-locale", stringArray, n + 1);
            if (StringHelper.isEmpty((String)string)) {
                throw new BadCommandLineException("No locale name provided. Use e.g. 'en_US'");
            }
            Locale.setDefault(LocaleCache.getInstance().getLocale(string));
            this.logInfo("Default Locale was set to '" + string + "'");
            return 2;
        }
        return 0;
    }

    public boolean run(@NonNull Outline outline, @NonNull Options options, @NonNull ErrorHandler errorHandler) {
        this.initPluginLogging(options.debugMode);
        return true;
    }
}

