/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.lang.IExplicitlyCloneable;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.jaxb.plugin.AbstractPluginCloneable;
import com.helger.jaxb.plugin.CJAXB;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginExplicitlyCloneable
extends AbstractPluginCloneable {
    public static final String OPT = "Xph-cloneable2";

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-cloneable2    :  implement clone() of IExplicitlyCloneable interface and cloneTo(target)";
    }

    public boolean run(@NonNull Outline outline, @NonNull Options options, @NonNull ErrorHandler errorHandler) {
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        JCodeModel jCodeModel = outline.getCodeModel();
        JClass jClass = jCodeModel.ref(Object.class);
        JClass jClass2 = jCodeModel.ref(IExplicitlyCloneable.class);
        JClass jClass3 = jCodeModel.ref(ArrayList.class);
        JClass jClass4 = jCodeModel.ref(HashMap.class);
        for (ClassOutline classOutline : outline.getClasses()) {
            boolean bl;
            JDefinedClass jDefinedClass = classOutline.implClass;
            boolean bl2 = bl = jDefinedClass._extends() == null || jDefinedClass._extends().equals(jClass);
            if (bl) {
                jDefinedClass._implements(jClass2);
            }
            ICommonsOrderedMap<JFieldVar, String> iCommonsOrderedMap = this.getAllInstanceFields(classOutline);
            JMethod jMethod = jDefinedClass.method(1, (JType)jCodeModel.VOID, "cloneTo");
            jMethod.javadoc().add((Object)"This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!");
            JVar jVar = jMethod.param((JType)jDefinedClass, "ret");
            jVar.annotate(NonNull.class);
            jMethod.javadoc().addParam(jVar).add((Object)"The target object to clone to. May not be <code>null</code>.");
            if (!bl) {
                jMethod.body().add((JStatement)JExpr._super().invoke(jMethod).arg((JExpression)jVar));
            }
            for (Map.Entry entry : iCommonsOrderedMap.entrySet()) {
                JConditional jConditional;
                JClass jClass5;
                JFieldVar jFieldVar = (JFieldVar)entry.getKey();
                if (jFieldVar.type().erasure().name().equals("List")) {
                    jClass5 = (JClass)((JClass)jFieldVar.type()).getTypeParameters().get(0);
                    jConditional = jMethod.body()._if(jFieldVar.eq(JExpr._null()));
                    jConditional._then().assign((JAssignmentTarget)jVar.ref((JVar)jFieldVar), JExpr._null());
                    JBlock jBlock = jConditional._else();
                    JVar jVar2 = jBlock.decl(jFieldVar.type(), "ret" + (String)entry.getValue(), (JExpression)JExpr._new((JClass)jClass3.narrow(jClass5)));
                    String string = CJAXB.getGetterName(jFieldVar.type(), (String)entry.getValue());
                    JForEach jForEach = jBlock.forEach((JType)jClass5, "aItem", (JExpression)JExpr.invoke((String)string));
                    jForEach.body().add((JStatement)jVar2.invoke("add").arg(this._getCloneCode(jCodeModel, (JExpression)jForEach.var(), (JType)jClass5)));
                    jBlock.assign((JAssignmentTarget)jVar.ref((JVar)jFieldVar), (JExpression)jVar2);
                    continue;
                }
                if (jFieldVar.type().erasure().name().equals("Map")) {
                    jClass5 = jMethod.body()._if(jFieldVar.eq(JExpr._null()));
                    jClass5._then().assign((JAssignmentTarget)jVar.ref((JVar)jFieldVar), JExpr._null());
                    jConditional = jClass5._else();
                    jConditional.assign((JAssignmentTarget)jVar.ref((JVar)jFieldVar), (JExpression)JExpr._new((JClass)jClass4.narrow(((JClass)jFieldVar.type()).getTypeParameters())).arg((JExpression)jFieldVar));
                    continue;
                }
                jMethod.body().assign((JAssignmentTarget)jVar.ref((JVar)jFieldVar), this._getCloneCode(jCodeModel, (JExpression)jFieldVar, jFieldVar.type()));
            }
            jMethod.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-cloneable2");
            if (jDefinedClass.isAbstract()) {
                jVar = jDefinedClass.method(33, (JType)jDefinedClass, "clone");
                jVar.annotate(NonNull.class);
                jVar.annotate(ReturnsMutableCopy.class);
                jVar.annotate(Override.class);
                jVar.javadoc().addReturn().add((Object)"The cloned object. Never <code>null</code>.");
                jVar.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-cloneable2");
            } else {
                jVar = jDefinedClass.method(1, (JType)jDefinedClass, "clone");
                jVar.annotate(NonNull.class);
                jVar.annotate(ReturnsMutableCopy.class);
                jVar.annotate(Override.class);
                jVar.javadoc().addReturn().add((Object)"The cloned object. Never <code>null</code>.");
                JVar jVar3 = jVar.body().decl((JType)jDefinedClass, "ret", (JExpression)JExpr._new((JClass)jDefinedClass));
                jVar.body().invoke(jMethod).arg((JExpression)jVar3);
                jVar.body()._return((JExpression)jVar3);
                jVar.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-cloneable2");
            }
            jDefinedClass.javadoc().add((Object)"<p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>\n");
        }
        return true;
    }
}

