/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import org.jspecify.annotations.NonNull;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginFieldsPrivate
extends AbstractPlugin {
    public static final String OPT = "Xph-fields-private";

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-fields-private    :  mark all fields as private";
    }

    public boolean run(@NonNull Outline outline, @NonNull Options options, @NonNull ErrorHandler errorHandler) {
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        for (ClassOutline classOutline : outline.getClasses()) {
            JDefinedClass jDefinedClass = classOutline.implClass;
            for (JFieldVar jFieldVar : jDefinedClass.fields().values()) {
                jFieldVar.mods().setPrivate();
            }
        }
        return true;
    }
}

