/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.graph.IMutableDirectedGraphNode;
import com.helger.graph.simple.SimpleDirectedGraph;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.Serializable;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginImplements
extends AbstractPlugin {
    public static final String OPT = "Xph-implements";
    private static final String GRAPH_ATTR_VALUE = "value";
    private ICommonsList<String> m_aInterfacesToImplement;

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-implements interfaceName[,interfaceName] :  implement 1-n interfaces in all classes/enums";
    }

    public int parseArgument(Options options, String[] stringArray, int n) throws BadCommandLineException {
        if (stringArray[n].equals("-Xph-implements")) {
            String string = options.requireArgument("-Xph-implements", stringArray, n + 1);
            this.m_aInterfacesToImplement = RegExHelper.getSplitToList((CharSequence)string, (String)"[,;]+");
            if (this.m_aInterfacesToImplement.isEmpty()) {
                throw new BadCommandLineException("No interface names provided. They must be seprated by comma (,) or semicolon (;)");
            }
            return 2;
        }
        return 0;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        Object object;
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        JCodeModel jCodeModel = outline.getCodeModel();
        SimpleDirectedGraph simpleDirectedGraph = new SimpleDirectedGraph();
        for (Object object2 : outline.getClasses()) {
            simpleDirectedGraph.createNode(((ClassOutline)object2).implClass.fullName()).attrs().putIn((Object)GRAPH_ATTR_VALUE, (Object)((ClassOutline)object2).implClass);
        }
        for (Object object2 : outline.getClasses()) {
            object = (IMutableDirectedGraphNode)simpleDirectedGraph.getNodeOfID(((ClassOutline)object2).implClass._extends().fullName());
            if (object == null) continue;
            simpleDirectedGraph.createRelation((IMutableDirectedGraphNode)object, (IMutableDirectedGraphNode)simpleDirectedGraph.getNodeOfID(((ClassOutline)object2).implClass.fullName()));
        }
        for (Object object2 : this.m_aInterfacesToImplement) {
            object = ((String)object2).trim();
            JClass jClass = jCodeModel.ref((String)object);
            for (IMutableDirectedGraphNode iMutableDirectedGraphNode : simpleDirectedGraph.getAllStartNodes()) {
                ((JDefinedClass)iMutableDirectedGraphNode.attrs().getCastedValue((Object)GRAPH_ATTR_VALUE))._implements(jClass);
            }
            if (((String)object).equals(Serializable.class.getName())) continue;
            for (IMutableDirectedGraphNode iMutableDirectedGraphNode : outline.getEnums()) {
                iMutableDirectedGraphNode.clazz._implements(jClass);
            }
        }
        return true;
    }
}

