/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.helger.jaxb.plugin.CJAXB;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginListExtension
extends AbstractPlugin {
    public static final String OPT = "Xph-list-extension";
    private static final boolean USE_COMMONS_LIST = false;
    private static final JType[] JTYPE_EMPTY = new JType[0];

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-list-extension :  add additional methods for List types";
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        JCodeModel jCodeModel = outline.getCodeModel();
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        for (ClassOutline classOutline : outline.getClasses()) {
            JVar jVar;
            Object object;
            String string;
            Object object2;
            JType jType;
            JDefinedClass jDefinedClass = classOutline.implClass;
            for (JFieldVar jFieldVar : jDefinedClass.fields().values()) {
                jType = jFieldVar.type();
                if (!jType.erasure().name().equals("List")) continue;
                object2 = jCodeModel.ref(ICommonsList.class).narrow(((JClass)jType).getTypeParameters());
                string = classOutline.target.getProperty(jFieldVar.name()).getName(true);
                object = jDefinedClass.method(1, (JType)jCodeModel.VOID, CJAXB.getSetterName(string));
                jVar = object.param(8, jFieldVar.type(), "aList");
                jVar.annotate(Nullable.class);
                object.body().assign((JAssignmentTarget)jFieldVar, (JExpression)jVar);
                object.javadoc().addParam(jVar).add((Object)"The new list member to set. May be <code>null</code>.");
                object.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-list-extension");
                commonsHashSet.add((Object)jDefinedClass);
            }
            for (JFieldVar jFieldVar : new CommonsArrayList(jDefinedClass.methods())) {
                if (!jFieldVar.name().startsWith("get") || !jFieldVar.params().isEmpty() || !(jType = jFieldVar.type()).erasure().name().equals("List")) continue;
                object2 = jFieldVar.name().substring(3);
                string = (JType)((JClass)jType).getTypeParameters().get(0);
                object = jDefinedClass.method(1, (JType)jCodeModel.BOOLEAN, "has" + (String)object2 + "Entries");
                object.body()._return(JOp.not((JExpression)JExpr.invoke((JMethod)jFieldVar).invoke("isEmpty")));
                object.javadoc().addReturn().add((Object)"<code>true</code> if at least one item is contained, <code>false</code> otherwise.");
                object.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-list-extension");
                object = jDefinedClass.method(1, (JType)jCodeModel.BOOLEAN, "hasNo" + (String)object2 + "Entries");
                object.body()._return((JExpression)JExpr.invoke((JMethod)jFieldVar).invoke("isEmpty"));
                object.javadoc().addReturn().add((Object)"<code>true</code> if no item is contained, <code>false</code> otherwise.");
                object.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-list-extension");
                object = "get" + (String)object2 + "Count";
                if (jDefinedClass.getMethod((String)object, JTYPE_EMPTY) != null) {
                    object = "get" + (String)object2 + "ListCount";
                }
                if (jDefinedClass.getMethod((String)object, JTYPE_EMPTY) == null) {
                    jVar = jDefinedClass.method(1, (JType)jCodeModel.INT, (String)object);
                    jVar.annotate(Nonnegative.class);
                    jVar.body()._return((JExpression)JExpr.invoke((JMethod)jFieldVar).invoke("size"));
                    jVar.javadoc().addReturn().add((Object)"The number of contained elements. Always &ge; 0.");
                    jVar.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-list-extension");
                } else {
                    this.logWarn("Cannot create 'get" + (String)object2 + "Count' method because it already exists");
                }
                object = jDefinedClass.method(1, (JType)string, "get" + (String)object2 + "AtIndex");
                object.annotate(Nullable.class);
                object._throws(IndexOutOfBoundsException.class);
                jVar = object.param(8, (JType)jCodeModel.INT, "index");
                jVar.annotate(Nonnegative.class);
                object.body()._return((JExpression)JExpr.invoke((JMethod)jFieldVar).invoke("get").arg((JExpression)jVar));
                object.javadoc().addParam(jVar).add((Object)"The index to retrieve");
                object.javadoc().addReturn().add((Object)"The element at the specified index. May be <code>null</code>");
                object.javadoc().addThrows(IndexOutOfBoundsException.class).add((Object)"if the index is invalid!");
                object.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-list-extension");
                object = jDefinedClass.method(1, (JType)jCodeModel.VOID, "add" + (String)object2);
                jVar = object.param(8, (JType)string, "elem");
                jVar.annotate(NonNull.class);
                object.body().add((JStatement)JExpr.invoke((JMethod)jFieldVar).invoke("add").arg((JExpression)jVar));
                object.javadoc().addParam(jVar).add((Object)"The element to be added. May not be <code>null</code>.");
                object.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-list-extension");
                commonsHashSet.add((Object)jDefinedClass);
            }
        }
        for (ClassOutline classOutline : commonsHashSet) {
            classOutline.javadoc().add((Object)"<p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>\n");
        }
        return true;
    }
}

