/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.generator.bean.PackageOutlineImpl;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIXPluginCustomization;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.impl.SchemaImpl;
import jakarta.xml.bind.annotation.XmlNs;
import jakarta.xml.bind.annotation.XmlSchema;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginNamespacePrefix
extends AbstractPlugin {
    public static final String OPT = "Xph-namespace-prefix";
    public static final String NAMESPACE_URI = "http://www.helger.com/namespaces/jaxb/plugin/namespace-prefix";

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "-Xph-namespace-prefix : activate namespaces prefix customizations";
    }

    @Override
    public List<String> getCustomizationURIs() {
        return new CommonsArrayList((Object)NAMESPACE_URI);
    }

    public boolean isCustomizationTagName(String string, String string2) {
        return NAMESPACE_URI.equals(string) && "prefix".equals(string2);
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        JClass jClass = outline.getCodeModel().ref(XmlNs.class);
        JClass jClass2 = outline.getCodeModel().ref(XmlSchema.class);
        for (PackageOutline packageOutline : outline.getAllPackageContexts()) {
            JPackage jPackage = packageOutline._package();
            Set<String> set = PluginNamespacePrefix._getPackageNamespace(packageOutline);
            Model model = PluginNamespacePrefix._getPackageModel((PackageOutlineImpl)packageOutline);
            List<Pair> list = PluginNamespacePrefix._getPrefixBinding(model, set);
            this._acknowledgePrefixAnnotations(model);
            if (list == null || list.isEmpty()) continue;
            JAnnotationUse jAnnotationUse = PluginNamespacePrefix._getOrAddXmlSchemaAnnotation(jPackage, jClass2);
            if (jAnnotationUse == null) {
                throw new RuntimeException("Unable to get/add 'XmlSchema' annotation to package [" + jPackage.name() + "]");
            }
            JAnnotationArrayMember jAnnotationArrayMember = jAnnotationUse.paramArray("xmlns");
            for (Pair pair : list) {
                JAnnotationUse jAnnotationUse2 = jAnnotationArrayMember.annotate(jClass);
                jAnnotationUse2.param("prefix", pair.getPrefix());
                jAnnotationUse2.param("namespaceURI", pair.getNamespace());
            }
        }
        return true;
    }

    private static @NonNull Set<String> _getPackageNamespace(PackageOutline packageOutline) {
        Map<String, Integer> map = PluginNamespacePrefix._getUriCountMap(packageOutline);
        return map == null ? Collections.emptySet() : map.keySet();
    }

    private void _acknowledgePrefixAnnotations(Model model) {
        CCustomizations cCustomizations = model.getCustomizations();
        if (cCustomizations != null) {
            for (CPluginCustomization cPluginCustomization : cCustomizations) {
                if (!cPluginCustomization.element.getNamespaceURI().equals(NAMESPACE_URI)) continue;
                if (!cPluginCustomization.element.getLocalName().equals("prefix")) {
                    throw new RuntimeException("Unrecognized element [" + cPluginCustomization.element.getLocalName() + "]");
                }
                cPluginCustomization.markAsAcknowledged();
            }
        }
    }

    private static List<Pair> _getPrefixBinding(Model model, Set<String> set) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (XSSchema xSSchema : model.schemaComponent.getSchemas()) {
            BindInfo bindInfo;
            String string;
            Object object;
            SchemaImpl schemaImpl = (SchemaImpl)xSSchema;
            XSAnnotation xSAnnotation = schemaImpl.getAnnotation();
            if (xSAnnotation == null || (object = xSAnnotation.getAnnotation()) == null || !(object instanceof BindInfo) || !set.contains(string = (bindInfo = (BindInfo)object).getOwner().getOwnerSchema().getTargetNamespace())) continue;
            String string2 = "";
            for (BIDeclaration bIDeclaration : bindInfo.getDecls()) {
                if (!(bIDeclaration instanceof BIXPluginCustomization)) continue;
                BIXPluginCustomization bIXPluginCustomization = (BIXPluginCustomization)bIDeclaration;
                if (!bIXPluginCustomization.element.getNamespaceURI().equals(NAMESPACE_URI)) continue;
                if (!bIXPluginCustomization.element.getLocalName().equals("prefix")) {
                    throw new RuntimeException("Unrecognized element [" + bIXPluginCustomization.element.getLocalName() + "]");
                }
                string2 = bIXPluginCustomization.element.getAttribute("name");
                bIXPluginCustomization.markAsAcknowledged();
                break;
            }
            arrayList.add(new Pair(string, string2));
        }
        return arrayList;
    }

    private static JAnnotationUse _getOrAddXmlSchemaAnnotation(JPackage jPackage, JClass jClass) {
        JAnnotationUse jAnnotationUse = null;
        Collection collection = jPackage.annotations();
        if (collection != null) {
            for (JAnnotationUse jAnnotationUse2 : collection) {
                JClass jClass2 = jAnnotationUse2.getAnnotationClass();
                if (jClass2 != jClass) continue;
                jAnnotationUse = jAnnotationUse2;
                break;
            }
        }
        if (jAnnotationUse == null) {
            jAnnotationUse = jPackage.annotate(jClass);
        }
        return jAnnotationUse;
    }

    private static Map<String, Integer> _getUriCountMap(PackageOutline packageOutline) {
        try {
            Field field = PackageOutlineImpl.class.getDeclaredField("uriCountMap");
            field.setAccessible(true);
            return (Map)field.get(packageOutline);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Unable to access 'uriCountMap' field for package outline [" + packageOutline._package().name() + "] : " + noSuchFieldException.getMessage(), noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Unable to find 'uriCountMap' field for package outline [" + packageOutline._package().name() + "] : " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    private static Model _getPackageModel(PackageOutlineImpl packageOutlineImpl) {
        try {
            Field field = PackageOutlineImpl.class.getDeclaredField("_model");
            field.setAccessible(true);
            return (Model)field.get(packageOutlineImpl);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Unable to access '_model' field for package outline [" + packageOutlineImpl._package().name() + "] : " + noSuchFieldException.getMessage(), noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Unable to find '_model' field for package outline [" + packageOutlineImpl._package().name() + "] : " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    private static final class Pair {
        private final String m_sNamespace;
        private final String m_sPrefix;

        private Pair(String string, String string2) {
            this.m_sNamespace = string;
            this.m_sPrefix = string2;
        }

        public String getNamespace() {
            return this.m_sNamespace;
        }

        public String getPrefix() {
            return this.m_sPrefix;
        }
    }
}

