/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.datetime.xml.XMLOffsetTime;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.helger.jaxb.plugin.CJAXB;
import com.helger.jaxb.plugin.cm.MyTernaryOp;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginOffsetDTExtension
extends AbstractPlugin {
    public static final String OPT = "Xph-offset-dt-extension";

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-offset-dt-extension :  add additional methods for Offset* date time types";
    }

    public static @Nullable JType getSecondaryDataType(@NonNull JType jType, @NonNull JCodeModel jCodeModel) {
        switch (jType.name()) {
            case "OffsetDate": 
            case "XMLOffsetDate": {
                return jCodeModel.ref(LocalDate.class);
            }
            case "OffsetTime": 
            case "XMLOffsetTime": {
                return jCodeModel.ref(LocalTime.class);
            }
            case "OffsetDateTime": 
            case "XMLOffsetDateTime": {
                return jCodeModel.ref(LocalDateTime.class);
            }
        }
        return null;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        JCodeModel jCodeModel = outline.getCodeModel();
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        for (ClassOutline classOutline : outline.getClasses()) {
            JDefinedClass jDefinedClass = classOutline.implClass;
            for (JFieldVar jFieldVar : jDefinedClass.fields().values()) {
                JType jType = jFieldVar.type();
                switch (jType.name()) {
                    case "OffsetDate": 
                    case "XMLOffsetDate": {
                        JClass jClass = jCodeModel.ref(LocalDate.class);
                        boolean bl = jType.name().equals("XMLOffsetDate");
                        JMethod jMethod = jDefinedClass.method(1, (JType)jClass, CJAXB.getGetterName(jType, jFieldVar.name()) + "Local");
                        jMethod.annotate(Nullable.class);
                        jMethod.body()._return((JExpression)MyTernaryOp.cond(jFieldVar.eq(JExpr._null()), JExpr._null(), (JExpression)jFieldVar.invoke("toLocalDate")));
                        jMethod.javadoc().addReturn().add((Object)("The LocalDate representation of " + jFieldVar.name() + ". May be <code>null</code>."));
                        jMethod.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-offset-dt-extension");
                        jMethod = jDefinedClass.method(1, (JType)jCodeModel.VOID, CJAXB.getSetterName(jFieldVar.name()));
                        JVar jVar = jMethod.param(8, (JType)jClass, "aValue");
                        jVar.annotate(Nullable.class);
                        jMethod.body().assign((JAssignmentTarget)jFieldVar, (JExpression)MyTernaryOp.cond(jVar.eq(JExpr._null()), JExpr._null(), (JExpression)(bl ? jCodeModel.ref(XMLOffsetDate.class).staticInvoke("of").arg((JExpression)jVar).arg(JExpr._null()) : jCodeModel.ref(OffsetDate.class).staticInvoke("of").arg((JExpression)jVar).arg((JExpression)jCodeModel.ref(ZoneOffset.class).staticRef("UTC")))));
                        jMethod.javadoc().addParam(jVar).add((Object)"The LocalDate to set. May be <code>null</code>.");
                        jMethod.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-offset-dt-extension");
                        commonsHashSet.add((Object)jDefinedClass);
                        break;
                    }
                    case "OffsetTime": 
                    case "XMLOffsetTime": {
                        JClass jClass = jCodeModel.ref(LocalTime.class);
                        boolean bl = jType.name().equals("XMLOffsetTime");
                        JMethod jMethod = jDefinedClass.method(1, (JType)jClass, CJAXB.getGetterName(jType, jFieldVar.name()) + "Local");
                        jMethod.annotate(Nullable.class);
                        jMethod.body()._return((JExpression)MyTernaryOp.cond(jFieldVar.eq(JExpr._null()), JExpr._null(), (JExpression)jFieldVar.invoke("toLocalTime")));
                        jMethod.javadoc().addReturn().add((Object)("The LocalTime representation of " + jFieldVar.name() + ". May be <code>null</code>."));
                        jMethod.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-offset-dt-extension");
                        jMethod = jDefinedClass.method(1, (JType)jCodeModel.VOID, CJAXB.getSetterName(jFieldVar.name()));
                        JVar jVar = jMethod.param(8, (JType)jClass, "aValue");
                        jVar.annotate(Nullable.class);
                        jMethod.body().assign((JAssignmentTarget)jFieldVar, (JExpression)MyTernaryOp.cond(jVar.eq(JExpr._null()), JExpr._null(), (JExpression)(bl ? jCodeModel.ref(XMLOffsetTime.class).staticInvoke("of").arg((JExpression)jVar).arg(JExpr._null()) : jCodeModel.ref(OffsetTime.class).staticInvoke("of").arg((JExpression)jVar).arg((JExpression)jCodeModel.ref(ZoneOffset.class).staticRef("UTC")))));
                        jMethod.javadoc().addParam(jVar).add((Object)"The LocalTime to set. May be <code>null</code>.");
                        jMethod.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-offset-dt-extension");
                        commonsHashSet.add((Object)jDefinedClass);
                        break;
                    }
                    case "OffsetDateTime": 
                    case "XMLOffsetDateTime": {
                        JClass jClass = jCodeModel.ref(LocalDateTime.class);
                        boolean bl = jType.name().equals("XMLOffsetDateTime");
                        JMethod jMethod = jDefinedClass.method(1, (JType)jClass, CJAXB.getGetterName(jType, jFieldVar.name()) + "Local");
                        jMethod.annotate(Nullable.class);
                        jMethod.body()._return((JExpression)MyTernaryOp.cond(jFieldVar.eq(JExpr._null()), JExpr._null(), (JExpression)jFieldVar.invoke("toLocalDateTime")));
                        jMethod.javadoc().addReturn().add((Object)("The LocalDateTime representation of " + jFieldVar.name() + ". May be <code>null</code>."));
                        jMethod.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-offset-dt-extension");
                        jMethod = jDefinedClass.method(1, (JType)jCodeModel.VOID, CJAXB.getSetterName(jFieldVar.name()));
                        JVar jVar = jMethod.param(8, (JType)jClass, "aValue");
                        jVar.annotate(Nullable.class);
                        jMethod.body().assign((JAssignmentTarget)jFieldVar, (JExpression)MyTernaryOp.cond(jVar.eq(JExpr._null()), JExpr._null(), (JExpression)(bl ? jCodeModel.ref(XMLOffsetDateTime.class).staticInvoke("of").arg((JExpression)jVar).arg(JExpr._null()) : jCodeModel.ref(OffsetDateTime.class).staticInvoke("of").arg((JExpression)jVar).arg((JExpression)jCodeModel.ref(ZoneOffset.class).staticRef("UTC")))));
                        jMethod.javadoc().addParam(jVar).add((Object)"The LocalDateTime to set. May be <code>null</code>.");
                        jMethod.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-offset-dt-extension");
                        commonsHashSet.add((Object)jDefinedClass);
                        break;
                    }
                }
            }
        }
        for (ClassOutline classOutline : commonsHashSet) {
            classOutline.javadoc().add((Object)"<p>This class contains methods created by ph-jaxb-plugin -Xph-offset-dt-extension</p>\n");
        }
        return true;
    }
}

