/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import org.jspecify.annotations.NonNull;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginToString
extends AbstractPlugin {
    public static final String OPT = "Xph-tostring";

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-tostring    :  auto implement toString using com.helger.base.string.ToStringGenerator";
    }

    private static @NonNull String _ucFirst(@NonNull String string) {
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public boolean run(@NonNull Outline outline, @NonNull Options options, @NonNull ErrorHandler errorHandler) {
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        JCodeModel jCodeModel = outline.getCodeModel();
        JClass jClass = jCodeModel.ref(Object.class);
        JClass jClass2 = jCodeModel.ref(ToStringGenerator.class);
        for (ClassOutline classOutline : outline.getClasses()) {
            boolean bl;
            JDefinedClass jDefinedClass = classOutline.implClass;
            FieldOutline[] fieldOutlineArray = classOutline.getDeclaredFields();
            boolean bl2 = bl = jDefinedClass._extends() == null || jDefinedClass._extends().equals(jClass);
            if (!bl && fieldOutlineArray.length == 0) continue;
            ICommonsOrderedMap<JFieldVar, String> iCommonsOrderedMap = this.getAllInstanceFields(classOutline);
            JMethod jMethod = jDefinedClass.method(1, (JType)jCodeModel.ref(String.class), "toString");
            jMethod.annotate(Override.class);
            JInvocation jInvocation = bl ? JExpr._new((JClass)jClass2).arg(JExpr._this()) : jClass2.staticInvoke("getDerived").arg((JExpression)JExpr._super().invoke(jMethod));
            for (JFieldVar jFieldVar : iCommonsOrderedMap.keySet()) {
                String string = jFieldVar.name();
                jInvocation = jInvocation.invoke("append").arg(JExpr.lit((String)PluginToString._ucFirst(string))).arg((JExpression)JExpr.ref((String)string));
            }
            jMethod.body()._return((JExpression)jInvocation.invoke("getToString"));
            jMethod.javadoc().add((Object)"Created by ph-jaxb-plugin -Xph-tostring");
            jDefinedClass.javadoc().add((Object)"<p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>\n");
        }
        return true;
    }
}

