/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.plugin;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.reflection.GenericReflection;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.commons.ICommonsNavigableMap;
import com.helger.collection.commons.ICommonsNavigableSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.jaxb.plugin.AbstractPlugin;
import com.helger.jaxb.plugin.PluginOffsetDTExtension;
import com.helger.jaxb.plugin.cm.MyTernaryOp;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.xml.sax.ErrorHandler;

@IsSPIImplementation
public class PluginValueExtender
extends AbstractPlugin {
    private static final String FIELD_VALUE = "value";
    public static final String OPT = "Xph-value-extender";
    public static final String AUTHOR = "<br>\nNote: automatically created by ph-jaxb-plugin -Xph-value-extender";
    private static final Comparator<ClassOutline> COMP_CO = Comparator.comparing(classOutline -> classOutline.getImplClass().fullName());

    public String getOptionName() {
        return OPT;
    }

    public String getUsage() {
        return "  -Xph-value-extender    :  create additional constructors with the 'value' as argument + getter and setter for the value";
    }

    private static @NonNull ICommonsNavigableSet<ClassOutline> _getSortedClassOutlines(@NonNull Outline outline) {
        CommonsTreeSet commonsTreeSet = new CommonsTreeSet(COMP_CO);
        commonsTreeSet.addAll(outline.getClasses());
        return commonsTreeSet;
    }

    private void _addDefaultCtors(@NonNull Outline outline) {
        for (ClassOutline classOutline : outline.getClasses()) {
            JDefinedClass jDefinedClass = classOutline.implClass;
            JMethod jMethod = jDefinedClass.constructor(1);
            jMethod.javadoc().add((Object)"Default constructor");
            jMethod.javadoc().add((Object)AUTHOR);
            jDefinedClass.javadoc().add((Object)"<p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>\n");
        }
        this.logDebug(() -> "Added default constructors to " + outline.getClasses().size() + " classes");
    }

    @ReturnsMutableCopy
    private @NonNull ICommonsNavigableMap<String, JType> _addValueCtors(@NonNull Outline outline, boolean bl) {
        JCodeModel jCodeModel = outline.getCodeModel();
        ClassNameValueFieldTypeMap classNameValueFieldTypeMap = new ClassNameValueFieldTypeMap(outline);
        CommonsTreeMap commonsTreeMap = new CommonsTreeMap();
        this.logDebug(() -> "Start creating value ctors");
        for (ClassOutline classOutline : PluginValueExtender._getSortedClassOutlines(outline)) {
            JDefinedClass jDefinedClass = classOutline.implClass;
            String string = jDefinedClass.fullName();
            this.logDebug(() -> "  Handling class '" + string + "'");
            JType jType = classNameValueFieldTypeMap.getValueFieldTypeIncludeHierarchy(jDefinedClass);
            if (jType != null) {
                this.logDebug(() -> "    New value ctor '" + jDefinedClass.name() + "(" + jType.name() + ")'");
                JMethod jMethod = jDefinedClass.constructor(1);
                JVar jVar = jMethod.param(8, jType, "valueParam");
                if (!jType.isPrimitive()) {
                    jVar.annotate(Nullable.class);
                }
                jMethod.body().invoke("setValue").arg((JExpression)jVar);
                jMethod.javadoc().add((Object)("Constructor for value of type " + jType.erasure().name()));
                jMethod.javadoc().addParam(jVar).add((Object)("The value to be set." + (jType.isPrimitive() ? "" : " May be <code>null</code>.")));
                jMethod.javadoc().add((Object)AUTHOR);
                if (bl && (jMethod = PluginOffsetDTExtension.getSecondaryDataType(jType, jCodeModel)) != null) {
                    this.logDebug(() -> PluginValueExtender.lambda$_addValueCtors$5(jDefinedClass, (JType)jMethod));
                    jVar = jDefinedClass.constructor(1);
                    JVar jVar2 = jVar.param(8, (JType)jMethod, "valueParam");
                    jVar2.annotate(Nullable.class);
                    jVar.body().invoke("setValue").arg((JExpression)jVar2);
                    jVar.javadoc().add((Object)("Constructor for value of type " + jMethod.name()));
                    jVar.javadoc().addParam(jVar2).add((Object)"The value to be set. May be <code>null</code>.");
                    jVar.javadoc().add((Object)AUTHOR);
                }
                commonsTreeMap.put((Object)string, (Object)jType);
                continue;
            }
            this.logDebug(() -> "    Found no [value] field");
        }
        return commonsTreeMap;
    }

    private void _addValueSetters(@NonNull Outline outline, @NonNull ICommonsNavigableMap<String, JType> iCommonsNavigableMap, boolean bl) {
        this.logDebug(() -> "Start creating setters for value ctors");
        for (ClassOutline classOutline : PluginValueExtender._getSortedClassOutlines(outline)) {
            JDefinedClass jDefinedClass = classOutline.implClass;
            String string = jDefinedClass.fullName();
            this.logDebug(() -> "  Handling class '" + string + "'");
            for (JMethod jMethod : new CommonsArrayList(jDefinedClass.methods())) {
                List list;
                if (!jMethod.name().startsWith("set") || (list = jMethod.params()).size() != 1) continue;
                JType jType = ((JVar)list.get(0)).type();
                JType jType2 = (JType)iCommonsNavigableMap.get((Object)jType.fullName());
                if (jType2 == null) {
                    this.logDebug(() -> "    No setter for '" + jType.fullName() + "' because not found in constructor list");
                    continue;
                }
                this.logDebug(() -> "    New setter '" + jType.name() + " " + jMethod.name() + "(" + jType2.name() + ")'");
                JMethod jMethod2 = jDefinedClass.method(1, jType, jMethod.name());
                jMethod2.annotate(NonNull.class);
                JVar jVar = jMethod2.param(8, jType2, "valueParam");
                if (!jType2.isPrimitive()) {
                    jVar.annotate(Nullable.class);
                }
                JVar jVar2 = jMethod2.body().decl(jType, "aObj", (JExpression)JExpr.invoke((String)("get" + jMethod.name().substring(3))));
                JConditional jConditional = jMethod2.body()._if(jVar2.eq(JExpr._null()));
                jConditional._then().assign((JAssignmentTarget)jVar2, (JExpression)JExpr._new((JType)jType).arg((JExpression)jVar));
                jConditional._then().invoke(jMethod).arg((JExpression)jVar2);
                jConditional._else().invoke((JExpression)jVar2, "setValue").arg((JExpression)jVar);
                jMethod2.body()._return((JExpression)jVar2);
                jMethod2.javadoc().add((Object)("Special setter with value of type " + jVar.type().name()));
                jMethod2.javadoc().addParam(jVar).add((Object)("The value to be set." + (jType2.isPrimitive() ? "" : " May be <code>null</code>.")));
                jMethod2.javadoc().addReturn().add((Object)("The created intermediary object of type " + jType.name() + " and never <code>null</code>"));
                jMethod2.javadoc().add((Object)AUTHOR);
                if (!bl || (jMethod2 = PluginOffsetDTExtension.getSecondaryDataType(jType2, outline.getCodeModel())) == null) continue;
                this.logDebug(() -> PluginValueExtender.lambda$_addValueSetters$11(jType, jMethod, (JType)jMethod2));
                jVar = jDefinedClass.method(1, jType, jMethod.name());
                jVar.annotate(NonNull.class);
                jVar2 = jVar.param(8, (JType)jMethod2, "valueParam");
                jVar2.annotate(Nullable.class);
                jConditional = jVar.body().decl(jType, "aObj", (JExpression)JExpr.invoke((String)("get" + jMethod.name().substring(3))));
                JConditional jConditional2 = jVar.body()._if(jConditional.eq(JExpr._null()));
                jConditional2._then().assign((JAssignmentTarget)jConditional, (JExpression)JExpr._new((JType)jType).arg((JExpression)jVar2));
                jConditional2._then().invoke(jMethod).arg((JExpression)jConditional);
                jConditional2._else().invoke((JExpression)jConditional, "setValue").arg((JExpression)jVar2);
                jVar.body()._return((JExpression)jConditional);
                jVar.javadoc().add((Object)("Special setter with value of type " + jVar2.type().name()));
                jVar.javadoc().addParam(jVar2).add((Object)"The value to be set. May be <code>null</code>.");
                jVar.javadoc().addReturn().add((Object)("The created intermediary object of type " + jType.name() + " and never <code>null</code>"));
                jVar.javadoc().add((Object)AUTHOR);
            }
        }
    }

    private static boolean _containsMethodWithoutParams(@NonNull Collection<JMethod> collection, @NonNull String string) {
        for (JMethod jMethod : collection) {
            if (!jMethod.name().equals(string) || !jMethod.params().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void _addValueGetter(@NonNull Outline outline, @NonNull ICommonsNavigableMap<String, JType> iCommonsNavigableMap, boolean bl) {
        JCodeModel jCodeModel = outline.getCodeModel();
        this.logDebug(() -> "Start creating setters for value ctors");
        for (ClassOutline classOutline : PluginValueExtender._getSortedClassOutlines(outline)) {
            JDefinedClass jDefinedClass = classOutline.implClass;
            String string = jDefinedClass.fullName();
            this.logDebug(() -> "  Handling class '" + string + "'");
            for (JMethod jMethod : new CommonsArrayList(jDefinedClass.methods())) {
                JVar jVar;
                JVar jVar2;
                JMethod jMethod2;
                JType jType;
                JType jType2;
                if (!jMethod.name().startsWith("get") || !jMethod.params().isEmpty() || (jType2 = (JType)iCommonsNavigableMap.get((Object)(jType = jMethod.type()).fullName())) == null) continue;
                boolean bl2 = jType2 == jCodeModel.BOOLEAN;
                String string2 = bl2 ? "is" + jMethod.name().substring(3) + "Value" : jMethod.name() + "Value";
                if (PluginValueExtender._containsMethodWithoutParams(jDefinedClass.methods(), string2)) {
                    this.logWarn("Another method with name '" + string2 + "' and no parameters is already present in class '" + jDefinedClass.name() + "' - not creating it.");
                    continue;
                }
                if (jType2.isPrimitive()) {
                    this.logDebug(() -> "    New value getter '" + jType2.name() + " " + string2 + "(" + jType2.name() + ")'");
                    if (bl2) {
                        jMethod2 = jDefinedClass.method(1, jType2, string2);
                        jVar2 = jMethod2.param(8, jType2, "nullValue");
                        jVar = jMethod2.body().decl(jType, "aObj", (JExpression)JExpr.invoke((JMethod)jMethod));
                        jMethod2.body()._return((JExpression)MyTernaryOp.cond(jVar.eq(JExpr._null()), (JExpression)jVar2, (JExpression)jVar.invoke("isValue")));
                    } else {
                        jMethod2 = jDefinedClass.method(1, jType2, string2);
                        jVar2 = jMethod2.param(8, jType2, "nullValue");
                        jVar = jMethod2.body().decl(jType, "aObj", (JExpression)JExpr.invoke((JMethod)jMethod));
                        jMethod2.body()._return((JExpression)MyTernaryOp.cond(jVar.eq(JExpr._null()), (JExpression)jVar2, (JExpression)jVar.invoke("getValue")));
                    }
                    jMethod2.javadoc().add((Object)("Get the value of the contained " + jType.name() + " object"));
                    jMethod2.javadoc().addParam(jVar2).add((Object)"The value to be returned, if the owning object is <code>null</code>");
                    jMethod2.javadoc().addReturn().add((Object)("Either the value of the contained " + jType.name() + " object or the passed " + jVar2.name()));
                    jMethod2.javadoc().add((Object)AUTHOR);
                    continue;
                }
                this.logDebug(() -> "    New value getter '" + jType2.name() + " " + string2 + "()'");
                jMethod2 = jDefinedClass.method(1, jType2, string2);
                jMethod2.annotate(Nullable.class);
                jVar2 = jMethod2.body().decl(jType, "aObj", (JExpression)JExpr.invoke((JMethod)jMethod));
                jMethod2.body()._return((JExpression)MyTernaryOp.cond(jVar2.eq(JExpr._null()), JExpr._null(), (JExpression)jVar2.invoke("getValue")));
                jMethod2.javadoc().add((Object)("Get the value of the contained " + jType.name() + " object"));
                jMethod2.javadoc().addReturn().add((Object)("Either the value of the contained " + jType.name() + " object or <code>null</code>"));
                jMethod2.javadoc().add((Object)AUTHOR);
                if (!bl || (jMethod2 = PluginOffsetDTExtension.getSecondaryDataType(jType2, jCodeModel)) == null) continue;
                this.logDebug(() -> PluginValueExtender.lambda$_addValueGetter$16((JType)jMethod2, string2));
                jVar2 = jDefinedClass.method(1, (JType)jMethod2, string2 + "Local");
                jVar2.annotate(Nullable.class);
                jVar = jVar2.body().decl(jType, "aObj", (JExpression)JExpr.invoke((JMethod)jMethod));
                jVar2.body()._return((JExpression)MyTernaryOp.cond(jVar.eq(JExpr._null()), JExpr._null(), (JExpression)jVar.invoke("getValueLocal")));
                jVar2.javadoc().add((Object)("Get the value of the contained " + jType.name() + " object"));
                jVar2.javadoc().addReturn().add((Object)("Either the value of the contained " + jType.name() + " object or <code>null</code>"));
                jVar2.javadoc().add((Object)AUTHOR);
            }
        }
    }

    public boolean run(@NonNull Outline outline, @NonNull Options options, @NonNull ErrorHandler errorHandler) {
        this.initPluginLogging(options.debugMode);
        this.logInfo("Running JAXB plugin -" + this.getOptionName());
        boolean bl = CollectionFind.containsAny((Iterable)options.getAllPlugins(), plugin -> plugin.getOptionName().equals("Xph-offset-dt-extension"));
        if (bl) {
            this.logInfo("  Found OffsetDTExtension plugin");
        }
        this._addDefaultCtors(outline);
        ICommonsNavigableMap<String, JType> iCommonsNavigableMap = this._addValueCtors(outline, bl);
        this._addValueSetters(outline, iCommonsNavigableMap, bl);
        this._addValueGetter(outline, iCommonsNavigableMap, bl);
        this.logInfo("  Finished JAXB plugin -" + this.getOptionName());
        return true;
    }

    private static /* synthetic */ String lambda$_addValueGetter$16(JType jType, String string) {
        return "    New value getter '" + jType.name() + " " + string + "Local()'";
    }

    private static /* synthetic */ String lambda$_addValueSetters$11(JType jType, JMethod jMethod, JType jType2) {
        return "    New setter '" + jType.name() + " " + jMethod.name() + "(" + jType2.name() + ")'";
    }

    private static /* synthetic */ String lambda$_addValueCtors$5(JDefinedClass jDefinedClass, JType jType) {
        return "    New value ctor '" + jDefinedClass.name() + "(" + jType.name() + ")'";
    }

    final class ClassNameValueFieldTypeMap
    extends CommonsHashMap<String, JType> {
        private void _recursiveFill(@NonNull ICommonsSet<String> iCommonsSet, @NonNull JCodeModel jCodeModel, @NonNull JType jType) {
            String string = jType.fullName();
            if (string.startsWith("java.")) {
                return;
            }
            if (!iCommonsSet.add((Object)string)) {
                return;
            }
            if (jType instanceof JDefinedClass) {
                JDefinedClass jDefinedClass = (JDefinedClass)jType;
                PluginValueExtender.this.logDebug(() -> "  Scanning defined super class '" + string + "'");
                for (Map.Entry entry : jDefinedClass.fields().entrySet()) {
                    if (!((String)entry.getKey()).equals(PluginValueExtender.FIELD_VALUE)) continue;
                    this.put(string, ((JFieldVar)entry.getValue()).type());
                    PluginValueExtender.this.logDebug(() -> "    Found value field of type '" + ((JFieldVar)entry.getValue()).type().name() + "'");
                    break;
                }
                this._recursiveFill(iCommonsSet, jCodeModel, (JType)jDefinedClass._extends());
            } else {
                Class clazz = GenericReflection.getClassFromNameSafe((String)string);
                if (clazz != null) {
                    PluginValueExtender.this.logDebug(() -> "  Successfully loaded super class '" + string + "' via reflection");
                    for (Field field : clazz.getDeclaredFields()) {
                        if (!field.getName().equals(PluginValueExtender.FIELD_VALUE)) continue;
                        this.put(string, jCodeModel._ref(field.getType()));
                        PluginValueExtender.this.logDebug(() -> "    Found value field of type '" + field.getType().getName() + "'");
                        break;
                    }
                    this._recursiveFill(iCommonsSet, jCodeModel, (JType)jCodeModel.ref(clazz.getSuperclass()));
                } else {
                    PluginValueExtender.this.logWarn("  Failed to load super class '" + string + "' via reflection");
                }
            }
        }

        private void _fill(@NonNull Outline outline) {
            JCodeModel jCodeModel = outline.getCodeModel();
            CommonsHashSet commonsHashSet = new CommonsHashSet();
            for (ClassOutline classOutline : outline.getClasses()) {
                JDefinedClass jDefinedClass = classOutline.implClass;
                this._recursiveFill((ICommonsSet<String>)commonsHashSet, jCodeModel, (JType)jDefinedClass._extends());
            }
        }

        private void _addIfNotPresent(@NonNull String string, @NonNull JType jType) {
            if (!this.containsKey(string)) {
                this.put(string, jType);
            }
        }

        public ClassNameValueFieldTypeMap(Outline outline) {
            JCodeModel jCodeModel = outline.getCodeModel();
            this._fill(outline);
            this._addIfNotPresent("com.helger.xsds.ccts.cct.schemamodule.AmountType", (JType)jCodeModel.ref(BigDecimal.class));
            this._addIfNotPresent("com.helger.xsds.ccts.cct.schemamodule.BinaryObjectType", (JType)jCodeModel.ref(byte[].class));
            this._addIfNotPresent("com.helger.xsds.ccts.cct.schemamodule.CodeType", (JType)jCodeModel.ref(String.class));
            this._addIfNotPresent("com.helger.xsds.ccts.cct.schemamodule.DateTimeType", (JType)jCodeModel.ref(String.class));
            this._addIfNotPresent("com.helger.xsds.ccts.cct.schemamodule.IdentifierType", (JType)jCodeModel.ref(String.class));
            this._addIfNotPresent("com.helger.xsds.ccts.cct.schemamodule.MeasureType", (JType)jCodeModel.ref(BigDecimal.class));
            this._addIfNotPresent("com.helger.xsds.ccts.cct.schemamodule.NumericType", (JType)jCodeModel.ref(BigDecimal.class));
            this._addIfNotPresent("com.helger.xsds.ccts.cct.schemamodule.QuantityType", (JType)jCodeModel.ref(BigDecimal.class));
            this._addIfNotPresent("com.helger.xsds.ccts.cct.schemamodule.TextType", (JType)jCodeModel.ref(String.class));
            PluginValueExtender.this.logDebug(() -> "Found " + this.size() + " super classes with 'value' fields");
        }

        public @Nullable JType getValueFieldTypeIncludeHierarchy(@NonNull JDefinedClass jDefinedClass) {
            JType jType = null;
            for (JFieldVar jFieldVar : jDefinedClass.fields().values()) {
                if (!jFieldVar.name().equals(PluginValueExtender.FIELD_VALUE)) continue;
                jType = jFieldVar.type();
                PluginValueExtender.this.logDebug(() -> "    [" + jFieldVar.type().name() + " value] found directly in class");
                break;
            }
            JDefinedClass jDefinedClass2 = jDefinedClass;
            int n = 1;
            while (jDefinedClass2 != null && jType == null) {
                if ((jDefinedClass2 = jDefinedClass2._extends()) != null && (jType = (JType)this.get(jDefinedClass2.fullName())) != null) {
                    JType jType2 = jType;
                    JDefinedClass jDefinedClass3 = jDefinedClass2;
                    int n2 = n;
                    PluginValueExtender.this.logDebug(() -> ClassNameValueFieldTypeMap.lambda$getValueFieldTypeIncludeHierarchy$7(jType2, n2, (JClass)jDefinedClass3));
                }
                ++n;
            }
            return jType;
        }

        private static /* synthetic */ String lambda$getValueFieldTypeIncludeHierarchy$7(JType jType, int n, JClass jClass) {
            return "    [" + jType.name() + " value] found in parent[" + n + "] class '" + jClass.name() + "'";
        }

        private static /* synthetic */ String lambda$_recursiveFill$0(JType jType, String string) {
            return "!!" + jType.getClass().getSimpleName() + " -- " + string;
        }
    }
}

