/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.validation;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.IResourceLocation;
import com.helger.commons.error.ISeverityComparable;
import com.helger.commons.error.ResourceError;
import com.helger.commons.error.ResourceLocation;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.serialize.write.XMLWriter;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@NotThreadSafe
public abstract class AbstractValidationEventHandler
implements ValidationEventHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractValidationEventHandler.class);
    private final ValidationEventHandler m_aWrappedHandler;

    public AbstractValidationEventHandler() {
        this(null);
    }

    public AbstractValidationEventHandler(@Nullable ValidationEventHandler validationEventHandler) {
        this.m_aWrappedHandler = validationEventHandler;
    }

    @Nullable
    public final ValidationEventHandler getWrappedHandler() {
        return this.m_aWrappedHandler;
    }

    @Nonnull
    @OverrideOnDemand
    protected IErrorLevel getErrorLevel(int n) {
        switch (n) {
            case 0: {
                return EErrorLevel.WARN;
            }
            case 1: {
                return EErrorLevel.ERROR;
            }
            case 2: {
                return EErrorLevel.FATAL_ERROR;
            }
        }
        s_aLogger.warn("Unknown JAXB validation severity: " + n + "; defaulting to error");
        return EErrorLevel.ERROR;
    }

    @Nullable
    @OverrideOnDemand
    protected String getLocationResourceID(@Nullable ValidationEventLocator validationEventLocator) {
        if (validationEventLocator != null) {
            URL uRL = validationEventLocator.getURL();
            if (uRL != null) {
                return uRL.toString();
            }
            Object object = validationEventLocator.getObject();
            if (object != null) {
                return "obj: " + object.toString();
            }
            Node node = validationEventLocator.getNode();
            if (node != null) {
                return XMLWriter.getXMLString((Node)node);
            }
        }
        return null;
    }

    protected abstract void onEvent(@Nonnull IResourceError var1);

    @OverrideOnDemand
    protected boolean continueProcessing(@Nonnull IErrorLevel iErrorLevel) {
        return iErrorLevel.isLessSevereThan((ISeverityComparable)EErrorLevel.FATAL_ERROR);
    }

    public final boolean handleEvent(@Nonnull ValidationEvent validationEvent) {
        IErrorLevel iErrorLevel = this.getErrorLevel(validationEvent.getSeverity());
        ValidationEventLocator validationEventLocator = validationEvent.getLocator();
        ResourceLocation resourceLocation = new ResourceLocation(this.getLocationResourceID(validationEventLocator), validationEventLocator != null ? validationEventLocator.getLineNumber() : -1, validationEventLocator != null ? validationEventLocator.getColumnNumber() : -1);
        String string = validationEvent.getMessage();
        if (string == null) {
            if (validationEvent.getLinkedException() != null) {
                string = validationEvent.getLinkedException().getMessage();
                if (string == null) {
                    string = "Exception";
                }
            } else {
                string = "Validation event";
            }
        }
        this.onEvent((IResourceError)new ResourceError((IResourceLocation)resourceLocation, iErrorLevel, string, validationEvent.getLinkedException()));
        if (this.m_aWrappedHandler != null) {
            return this.m_aWrappedHandler.handleEvent(validationEvent);
        }
        return this.continueProcessing(iErrorLevel);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("wrappedHandler", (Object)this.m_aWrappedHandler).toString();
    }
}

