/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.validation;

import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.ISeverityComparable;
import com.helger.jaxb.validation.AbstractValidationEventHandler;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LoggingValidationEventHandler
extends AbstractValidationEventHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingValidationEventHandler.class);

    public LoggingValidationEventHandler() {
    }

    public LoggingValidationEventHandler(@Nullable ValidationEventHandler validationEventHandler) {
        super(validationEventHandler);
    }

    @Override
    protected void onEvent(@Nonnull IResourceError iResourceError) {
        String string = "JAXB " + iResourceError.getAsString(Locale.US);
        if (iResourceError.getErrorLevel().isLessOrEqualSevereThan((ISeverityComparable)EErrorLevel.WARN)) {
            s_aLogger.warn(string, iResourceError.getLinkedException());
        } else {
            s_aLogger.error(string, iResourceError.getLinkedException());
        }
    }
}

