/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.SAXReaderFactory;
import com.helger.xml.serialize.read.SAXReaderSettings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public interface IJAXBReader<JAXBTYPE> {
    public boolean isReadSecure();

    @Nullable
    default public JAXBTYPE read(@Nonnull InputSource inputSource) {
        return this.read(new SAXReaderSettings(), inputSource);
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull SAXReaderSettings sAXReaderSettings, @Nonnull InputSource inputSource) {
        ValueEnforcer.notNull((Object)sAXReaderSettings, (String)"Settings");
        ValueEnforcer.notNull((Object)inputSource, (String)"InputSource");
        if (this.isReadSecure()) {
            sAXReaderSettings.setFeatureValues(EXMLParserFeature.AVOID_XML_ATTACKS);
        }
        XMLReader xMLReader = SAXReaderFactory.createXMLReader();
        sAXReaderSettings.applyToSAXReader(xMLReader);
        return this.read(new SAXSource(xMLReader, inputSource));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        return this.read(InputSourceFactory.create((File)file));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        return this.read(InputSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        return this.read(InputSourceFactory.create((InputStream)inputStream));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Reader reader) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        return this.read(InputSourceFactory.create((Reader)reader));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"XML");
        return this.read(InputSourceFactory.create((byte[])byArray));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull((Object)byteBuffer, (String)"XML");
        return this.read(InputSourceFactory.create((ByteBuffer)byteBuffer));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"XML");
        return this.read(InputSourceFactory.create((String)string));
    }

    @Nullable
    public JAXBTYPE read(@Nonnull IJAXBUnmarshaller<JAXBTYPE> var1);

    @Nullable
    default public JAXBTYPE read(@Nonnull Source source) {
        ValueEnforcer.notNull((Object)source, (String)"Source");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(source, clazz));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Node node) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(node, clazz));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull XMLStreamReader xMLStreamReader) {
        ValueEnforcer.notNull((Object)xMLStreamReader, (String)"Reader");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(xMLStreamReader, clazz));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull XMLEventReader xMLEventReader) {
        ValueEnforcer.notNull((Object)xMLEventReader, (String)"Reader");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(xMLEventReader, clazz));
    }

    @FunctionalInterface
    public static interface IJAXBUnmarshaller<JAXBTYPE> {
        @Nonnull
        public JAXBElement<JAXBTYPE> doUnmarshal(@Nonnull Unmarshaller var1, @Nonnull Class<JAXBTYPE> var2) throws JAXBException;
    }
}

