/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.io.resource.IWritableResource;
import com.helger.commons.io.stream.ByteBufferOutputStream;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.xml.XMLFactory;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.serialize.MicroSAXHandler;
import com.helger.xml.transform.TransformResultFactory;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public interface IJAXBWriter<JAXBTYPE> {
    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull File file) {
        return this.write(JAXBTYPE, TransformResultFactory.create((File)file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull @WillClose OutputStream outputStream) {
        try {
            ESuccess eSuccess = this.write(JAXBTYPE, TransformResultFactory.create((OutputStream)outputStream));
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull @WillClose Writer writer) {
        try {
            ESuccess eSuccess = this.write(JAXBTYPE, TransformResultFactory.create((Writer)writer));
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)writer);
        }
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull ByteBuffer byteBuffer) {
        return this.write(JAXBTYPE, (OutputStream)new ByteBufferOutputStream(byteBuffer, false));
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull IWritableResource iWritableResource) {
        return this.write(JAXBTYPE, (Result)TransformResultFactory.create((IWritableResource)iWritableResource));
    }

    @Nonnull
    public ESuccess write(@Nonnull JAXBTYPE var1, @Nonnull IJAXBMarshaller<JAXBTYPE> var2);

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull Result result) {
        return this.write(JAXBTYPE, (Marshaller marshaller, JAXBElement<JAXBTYPE> jAXBElement) -> marshaller.marshal((Object)jAXBElement, result));
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull ContentHandler contentHandler) {
        return this.write(JAXBTYPE, (Marshaller marshaller, JAXBElement<JAXBTYPE> jAXBElement) -> marshaller.marshal((Object)jAXBElement, contentHandler));
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull @WillClose XMLStreamWriter xMLStreamWriter) {
        ESuccess eSuccess = this.write(JAXBTYPE, (Marshaller marshaller, JAXBElement<JAXBTYPE> jAXBElement) -> marshaller.marshal((Object)jAXBElement, xMLStreamWriter));
        try {
            xMLStreamWriter.flush();
            xMLStreamWriter.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IllegalStateException("Failed to close XMLStreamWriter", xMLStreamException);
        }
        return eSuccess;
    }

    @Nullable
    default public Document getAsDocument(@Nonnull JAXBTYPE JAXBTYPE) {
        Document document = XMLFactory.newDocument();
        return this.write(JAXBTYPE, TransformResultFactory.create((Node)document)).isSuccess() ? document : null;
    }

    @Nullable
    default public IMicroDocument getAsMicroDocument(@Nonnull JAXBTYPE JAXBTYPE) {
        MicroSAXHandler microSAXHandler = new MicroSAXHandler(false, null);
        return this.write(JAXBTYPE, (ContentHandler)microSAXHandler).isSuccess() ? microSAXHandler.getDocument() : null;
    }

    @Nullable
    default public String getAsString(@Nonnull JAXBTYPE JAXBTYPE) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        return this.write(JAXBTYPE, TransformResultFactory.create((Writer)nonBlockingStringWriter)).isSuccess() ? nonBlockingStringWriter.getAsString() : null;
    }

    @Nullable
    default public ByteBuffer getAsByteBuffer(@Nonnull JAXBTYPE JAXBTYPE) {
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();
        return this.write(JAXBTYPE, (OutputStream)byteBufferOutputStream).isFailure() ? null : byteBufferOutputStream.getBuffer();
    }

    @Nullable
    default public byte[] getAsBytes(@Nonnull JAXBTYPE JAXBTYPE) {
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();
        return this.write(JAXBTYPE, (OutputStream)byteBufferOutputStream).isFailure() ? null : byteBufferOutputStream.getAsByteArray();
    }

    @FunctionalInterface
    public static interface IJAXBMarshaller<JAXBTYPE> {
        public void doMarshal(@Nonnull Marshaller var1, @Nonnull JAXBElement<JAXBTYPE> var2) throws JAXBException;
    }
}

