/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.IsLocked;
import com.helger.commons.cache.AbstractNotifyingCache;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.state.EChange;
import com.helger.jaxb.JAXBContextCacheKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JAXBContextCache
extends AbstractNotifyingCache<JAXBContextCacheKey, JAXBContext> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(JAXBContextCache.class);
    private static boolean s_bDefaultInstantiated = false;

    private JAXBContextCache() {
        super(JAXBContextCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static JAXBContextCache getInstance() {
        JAXBContextCache jAXBContextCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return jAXBContextCache;
    }

    @Nullable
    @IsLocked(value=ELockType.WRITE)
    public JAXBContext getValueToCache(@Nullable JAXBContextCacheKey jAXBContextCacheKey) {
        if (jAXBContextCacheKey == null) {
            return null;
        }
        Package package_ = jAXBContextCacheKey.getPackage();
        ClassLoader classLoader = jAXBContextCacheKey.getClassLoader();
        if (GlobalDebug.isDebugMode()) {
            s_aLogger.info("Creating JAXB context for package " + package_.getName() + (classLoader == null ? "" : " using ClassLoader " + classLoader));
        }
        try {
            if (package_.getAnnotation(XmlSchema.class) == null && GenericReflection.getClassFromNameSafe((String)(package_.getName() + ".ObjectFactory")) == null) {
                s_aLogger.warn("The package " + package_.getName() + " does not seem to be JAXB generated! Trying to create a JAXBContext anyway.");
            }
            return JAXBContext.newInstance((String)package_.getName(), (ClassLoader)classLoader);
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for package '" + package_.getName() + "'" + (classLoader == null ? "" : " using ClassLoader " + classLoader);
            s_aLogger.error(string + ": " + jAXBException.getMessage());
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    @Nullable
    public JAXBContext getFromCache(@Nonnull Package package_) {
        return this.getFromCache(package_, (ClassLoader)null);
    }

    @Nullable
    public JAXBContext getFromCache(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        return (JAXBContext)this.getFromCache(new JAXBContextCacheKey(package_, classLoader));
    }

    @Nonnull
    public JAXBContext getFromCache(@Nonnull Class<?> clazz) {
        return this.getFromCache(clazz, (ClassLoader)null);
    }

    @Nonnull
    public JAXBContext getFromCache(@Nonnull Class<?> clazz, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        Package package_ = clazz.getPackage();
        if (package_.getAnnotation(XmlSchema.class) != null) {
            return this.getFromCache(package_, classLoader);
        }
        if (GlobalDebug.isDebugMode()) {
            s_aLogger.info("Creating JAXB context for class " + clazz.getName());
        }
        if (classLoader != null) {
            s_aLogger.warn("Package " + package_.getName() + " does not seem to be JAXB generated. Therefore a new JAXBContext is created and the provided ClassLoader is ignored!");
        }
        try {
            return JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for class '" + clazz.getName() + "'";
            s_aLogger.error(string + ": " + jAXBException.getMessage());
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    @Nonnull
    public EChange removeFromCache(@Nonnull Package package_) {
        return this.removeFromCache(new JAXBContextCacheKey(package_, null));
    }

    private static final class SingletonHolder {
        static final JAXBContextCache s_aInstance = new JAXBContextCache();

        private SingletonHolder() {
        }
    }
}

