/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.jaxb.JAXBContextCache;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.jaxb.builder.JAXBBuilderDefaultSettings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.Schema;

@NotThreadSafe
public abstract class AbstractJAXBBuilder<IMPLTYPE extends AbstractJAXBBuilder<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE>,
IHasClassLoader {
    protected final IJAXBDocumentType m_aDocType;
    private ClassLoader m_aClassLoader;
    private boolean m_bUseJAXBContextCache = JAXBBuilderDefaultSettings.isDefaultUseContextCache();

    public AbstractJAXBBuilder(@Nonnull IJAXBDocumentType iJAXBDocumentType) {
        this.m_aDocType = (IJAXBDocumentType)ValueEnforcer.notNull((Object)iJAXBDocumentType, (String)"DocType");
    }

    @Nonnull
    public IJAXBDocumentType getJAXBDocumentType() {
        return this.m_aDocType;
    }

    @Nullable
    public ClassLoader getClassLoader() {
        return this.m_aClassLoader;
    }

    @Nonnull
    public IMPLTYPE setClassLoader(@Nullable ClassLoader classLoader) {
        this.m_aClassLoader = classLoader;
        return (IMPLTYPE)((AbstractJAXBBuilder)this.thisAsT());
    }

    public boolean isUseJAXBContextCache() {
        return this.m_bUseJAXBContextCache;
    }

    @Nonnull
    public IMPLTYPE setUseJAXBContextCache(boolean bl) {
        this.m_bUseJAXBContextCache = bl;
        return (IMPLTYPE)((AbstractJAXBBuilder)this.thisAsT());
    }

    @Nullable
    protected final Schema getSchema() {
        return this.m_aDocType.getSchema(this.m_aClassLoader);
    }

    @Nonnull
    protected final JAXBContext getJAXBContext() throws JAXBException {
        if (this.m_bUseJAXBContextCache) {
            return JAXBContextCache.getInstance().getFromCache(this.m_aDocType.getImplementationClass(), this.m_aClassLoader);
        }
        return JAXBContext.newInstance((String)this.m_aDocType.getImplementationClass().getPackage().getName(), (ClassLoader)this.m_aClassLoader);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DocType", (Object)this.m_aDocType).appendIfNotNull("ClassLoader", (Object)this.m_aClassLoader).append("UseJAXBContextCache", this.m_bUseJAXBContextCache).toString();
    }
}

