/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.lang.GenericReflection;
import com.helger.jaxb.builder.AbstractJAXBBuilder;
import com.helger.jaxb.builder.IJAXBDocumentType;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractWritingJAXBBuilder<JAXBTYPE, IMPLTYPE extends AbstractWritingJAXBBuilder<JAXBTYPE, IMPLTYPE>>
extends AbstractJAXBBuilder<IMPLTYPE> {
    private IExceptionCallback<JAXBException> m_aExceptionHandler = new DefaultExceptionHandler();
    private Consumer<Marshaller> m_aMarshallerCustomizer;

    public AbstractWritingJAXBBuilder(@Nonnull IJAXBDocumentType iJAXBDocumentType) {
        super(iJAXBDocumentType);
    }

    @Nonnull
    public IExceptionCallback<JAXBException> getExceptionHandler() {
        return this.m_aExceptionHandler;
    }

    @Nonnull
    public IMPLTYPE setExceptionHandler(@Nonnull IExceptionCallback<JAXBException> iExceptionCallback) {
        this.m_aExceptionHandler = (IExceptionCallback)ValueEnforcer.notNull(iExceptionCallback, (String)"ExceptionHandler");
        return (IMPLTYPE)((AbstractWritingJAXBBuilder)this.thisAsT());
    }

    @Nullable
    public Consumer<Marshaller> getMarshallerCustomizer() {
        return this.m_aMarshallerCustomizer;
    }

    @Nonnull
    public IMPLTYPE setMarshallerCustomizer(@Nullable Consumer<Marshaller> consumer) {
        this.m_aMarshallerCustomizer = consumer;
        return (IMPLTYPE)((AbstractWritingJAXBBuilder)this.thisAsT());
    }

    @Nonnull
    @OverrideOnDemand
    protected Marshaller createMarshaller() throws JAXBException {
        JAXBContext jAXBContext = this.getJAXBContext();
        Marshaller marshaller = jAXBContext.createMarshaller();
        Schema schema = this.getSchema();
        if (schema != null) {
            marshaller.setSchema(schema);
        }
        return marshaller;
    }

    @Nonnull
    protected <T> JAXBElement<T> createJAXBElement(@Nonnull T t) {
        return new JAXBElement(new QName(this.m_aDocType.getNamespaceURI(), this.m_aDocType.getLocalName()), (Class)GenericReflection.uncheckedCast(t.getClass()), null, t);
    }

    public static class DefaultExceptionHandler
    implements IExceptionCallback<JAXBException> {
        private static final Logger s_aLogger = LoggerFactory.getLogger(DefaultExceptionHandler.class);

        public void onException(@Nonnull JAXBException jAXBException) {
            if (jAXBException instanceof MarshalException) {
                s_aLogger.error("Marshal exception writing object", (Throwable)jAXBException);
            } else {
                s_aLogger.warn("JAXB Exception writing object", (Throwable)jAXBException);
            }
        }
    }
}

