/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.xml.schema.IHasSchema;
import com.helger.xml.schema.XMLSchemaValidationHelper;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;

public interface IJAXBDocumentType
extends IHasSchema,
Serializable {
    @Nonnull
    public Class<?> getImplementationClass();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllXSDPaths();

    @Nonnull
    public String getNamespaceURI();

    @Nonnull
    @Nonempty
    public String getLocalName();

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<? extends IReadableResource> getAllXSDResources() {
        return CollectionHelper.newListMapped(this.getAllXSDPaths(), string -> new ClassPathResource(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<? extends IReadableResource> getAllXSDResources(@Nullable ClassLoader classLoader) {
        return CollectionHelper.newListMapped(this.getAllXSDPaths(), string -> new ClassPathResource(string, classLoader));
    }

    @Nullable
    public Schema getSchema(@Nullable ClassLoader var1);

    @Nullable
    default public Validator getValidator() {
        return this.getValidator(null);
    }

    @Nullable
    default public Validator getValidator(@Nullable ClassLoader classLoader) {
        Schema schema = this.getSchema(classLoader);
        return schema == null ? null : schema.newValidator();
    }

    @Nullable
    default public IErrorList validateXML(@Nonnull IReadableResource iReadableResource) {
        return this.validateXML(iReadableResource, null);
    }

    @Nullable
    default public IErrorList validateXML(@Nonnull IReadableResource iReadableResource, @Nullable ClassLoader classLoader) {
        Schema schema = this.getSchema(classLoader);
        return schema == null ? null : XMLSchemaValidationHelper.validate((Schema)schema, (IReadableResource)iReadableResource);
    }
}

