/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.NamespaceContext;

@ThreadSafe
public final class JAXBBuilderDefaultSettings {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bUseContextCache = true;
    @GuardedBy(value="s_aRWLock")
    private static ValidationEventHandler s_aEventHandler;
    @GuardedBy(value="s_aRWLock")
    private static NamespaceContext s_aNamespaceContext;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bFormattedOutput;
    @GuardedBy(value="s_aRWLock")
    private static Charset s_aCharset;
    @GuardedBy(value="s_aRWLock")
    private static String s_sIndentString;

    private JAXBBuilderDefaultSettings() {
    }

    public static void setDefaultUseContextCache(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bUseContextCache = bl;
            return s_bUseContextCache;
        });
    }

    public static boolean isDefaultUseContextCache() {
        return s_aRWLock.readLocked(() -> s_bUseContextCache);
    }

    public static void setDefaultValidationEventHandler(@Nullable ValidationEventHandler validationEventHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aEventHandler = validationEventHandler;
            return s_aEventHandler;
        });
    }

    @Nullable
    public static ValidationEventHandler getDefaultValidationEventHandler() {
        return (ValidationEventHandler)s_aRWLock.readLocked(() -> s_aEventHandler);
    }

    public static void setDefaultNamespaceContext(@Nullable NamespaceContext namespaceContext) {
        s_aRWLock.writeLocked(() -> {
            s_aNamespaceContext = namespaceContext;
            return s_aNamespaceContext;
        });
    }

    @Nullable
    public static NamespaceContext getDefaultNamespaceContext() {
        return (NamespaceContext)s_aRWLock.readLocked(() -> s_aNamespaceContext);
    }

    public static void setDefaultFormattedOutput(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bFormattedOutput = bl;
            return s_bFormattedOutput;
        });
    }

    public static boolean isDefaultFormattedOutput() {
        return s_aRWLock.readLocked(() -> s_bFormattedOutput);
    }

    public static void setDefaultCharset(@Nullable Charset charset) {
        s_aRWLock.writeLocked(() -> {
            s_aCharset = charset;
            return s_aCharset;
        });
    }

    @Nullable
    public static Charset getDefaultCharset() {
        return (Charset)s_aRWLock.readLocked(() -> s_aCharset);
    }

    public static void setDefaultIndentString(@Nullable String string) {
        s_aRWLock.writeLocked(() -> {
            s_sIndentString = string;
            return s_sIndentString;
        });
    }

    @Nullable
    public static String getDefaultIndentString() {
        return (String)s_aRWLock.readLocked(() -> s_sIndentString);
    }

    static {
        s_bFormattedOutput = false;
    }
}

