/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.xml.schema.XMLSchemaCache;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.validation.Schema;

@NotThreadSafe
public class JAXBDocumentType
implements IJAXBDocumentType {
    private final Class<?> m_aClass;
    private final ICommonsList<String> m_aXSDPaths;
    private final String m_sNamespaceURI;
    private final String m_sLocalName;
    private Schema m_aCachedSchema;

    public JAXBDocumentType(@Nonnull Class<?> clazz, @Nullable List<String> list, @Nullable Function<String, String> function) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        ValueEnforcer.noNullValue(list, (String)"XSDPaths");
        XmlType xmlType = clazz.getAnnotation(XmlType.class);
        if (xmlType == null) {
            throw new IllegalArgumentException("The passed class does not have an @XmlType annotation!");
        }
        Package package_ = clazz.getPackage();
        XmlSchema xmlSchema = package_.getAnnotation(XmlSchema.class);
        if (xmlSchema == null) {
            throw new IllegalArgumentException("The package '" + package_.getName() + "' has no @XmlSchema annotation!");
        }
        if (xmlSchema.namespace() == null) {
            throw new IllegalArgumentException("The package '" + package_.getName() + "' has no namespace URI in the @XmlSchema annotation!");
        }
        XmlRootElement xmlRootElement = clazz.getAnnotation(XmlRootElement.class);
        String string = xmlRootElement != null ? xmlRootElement.name() : xmlType.name();
        if (function != null) {
            string = function.apply(string);
        }
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("Failed to determine the local name of the element to be created!");
        }
        this.m_aClass = clazz;
        this.m_aXSDPaths = CollectionHelper.newList(list);
        this.m_sNamespaceURI = StringHelper.getNotNull((String)xmlSchema.namespace());
        this.m_sLocalName = string;
    }

    @Override
    @Nonnull
    public Class<?> getImplementationClass() {
        return this.m_aClass;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllXSDPaths() {
        return (ICommonsList)this.m_aXSDPaths.getClone();
    }

    @Override
    @Nonnull
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLocalName() {
        return this.m_sLocalName;
    }

    @Nonnull
    private Schema _createSchema(@Nullable ClassLoader classLoader) {
        ICommonsList<? extends IReadableResource> iCommonsList = this.getAllXSDResources(classLoader);
        Schema schema = XMLSchemaCache.getInstanceOfClassLoader((ClassLoader)classLoader).getSchema(iCommonsList);
        if (schema == null) {
            throw new IllegalStateException("Failed to create Schema from " + iCommonsList + " using class loader " + classLoader);
        }
        return schema;
    }

    @Override
    @Nullable
    public Schema getSchema(@Nullable ClassLoader classLoader) {
        if (this.m_aXSDPaths.isEmpty()) {
            return null;
        }
        if (classLoader != null) {
            return this._createSchema(classLoader);
        }
        if (this.m_aCachedSchema == null) {
            this.m_aCachedSchema = this._createSchema(classLoader);
        }
        return this.m_aCachedSchema;
    }
}

