/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.function.IFunction;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.jaxb.IJAXBReader;
import com.helger.jaxb.IJAXBWriter;
import com.helger.jaxb.JAXBContextCache;
import com.helger.jaxb.JAXBMarshallerHelper;
import com.helger.jaxb.validation.IValidationEventHandlerFactory;
import com.helger.xml.namespace.INamespaceContext;
import com.helger.xml.schema.XMLSchemaCache;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

@NotThreadSafe
public abstract class AbstractJAXBMarshaller<JAXBTYPE>
implements IHasClassLoader,
IJAXBReader<JAXBTYPE>,
IJAXBWriter<JAXBTYPE> {
    public static final boolean DEFAULT_READ_SECURE = true;
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractJAXBMarshaller.class);
    private final Class<JAXBTYPE> m_aType;
    private final ICommonsList<IReadableResource> m_aXSDs = new CommonsArrayList();
    private final IFunction<JAXBTYPE, JAXBElement<JAXBTYPE>> m_aWrapper;
    private IValidationEventHandlerFactory m_aVEHFactory;
    private boolean m_bReadSecure = true;
    private boolean m_bFormattedOutput = false;
    private INamespaceContext m_aNSContext;
    private Charset m_aCharset;
    private String m_sIndentString;
    private String m_sSchemaLocation;
    private boolean m_bUseContextCache = true;
    private ClassLoader m_aClassLoader;

    protected AbstractJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nonnull IFunction<JAXBTYPE, JAXBElement<JAXBTYPE>> iFunction) {
        this(clazz, null, iFunction);
    }

    protected AbstractJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nullable List<? extends IReadableResource> list, @Nonnull IFunction<JAXBTYPE, JAXBElement<JAXBTYPE>> iFunction) {
        this.m_aType = (Class)ValueEnforcer.notNull(clazz, (String)"Type");
        if (list != null) {
            ValueEnforcer.notEmptyNoNullValue(list, (String)"XSDs");
            this.m_aXSDs.addAll(list);
        }
        this.m_aWrapper = (IFunction)ValueEnforcer.notNull(iFunction, (String)"Wrapper");
    }

    public final void setClassLoader(@Nullable ClassLoader classLoader) {
        this.m_aClassLoader = classLoader;
    }

    @Nullable
    public final ClassLoader getClassLoader() {
        return this.m_aClassLoader;
    }

    public final void setValidationEventHandlerFactory(@Nullable IValidationEventHandlerFactory iValidationEventHandlerFactory) {
        this.m_aVEHFactory = iValidationEventHandlerFactory;
    }

    @Nullable
    public final IValidationEventHandlerFactory getValidationEventHandlerFactory() {
        return this.m_aVEHFactory;
    }

    @Override
    public final boolean isReadSecure() {
        return this.m_bReadSecure;
    }

    @Nonnull
    public final EChange setReadSecure(boolean bl) {
        if (bl == this.m_bReadSecure) {
            return EChange.UNCHANGED;
        }
        this.m_bReadSecure = bl;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public final NamespaceContext getNamespaceContext() {
        return this.m_aNSContext;
    }

    @Nonnull
    public EChange setNamespaceContext(@Nullable INamespaceContext iNamespaceContext) {
        if (EqualsHelper.equals((Object)iNamespaceContext, (Object)this.m_aNSContext)) {
            return EChange.UNCHANGED;
        }
        this.m_aNSContext = iNamespaceContext;
        return EChange.CHANGED;
    }

    @Override
    public final boolean isFormattedOutput() {
        return this.m_bFormattedOutput;
    }

    @Nonnull
    public final EChange setFormattedOutput(boolean bl) {
        if (bl == this.m_bFormattedOutput) {
            return EChange.UNCHANGED;
        }
        this.m_bFormattedOutput = bl;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public EChange setCharset(@Nullable Charset charset) {
        if (EqualsHelper.equals((Object)charset, (Object)this.m_aCharset)) {
            return EChange.UNCHANGED;
        }
        this.m_aCharset = charset;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getIndentString() {
        return this.m_sIndentString;
    }

    @Nonnull
    public EChange setIndentString(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sIndentString)) {
            return EChange.UNCHANGED;
        }
        this.m_sIndentString = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getSchemaLocation() {
        return this.m_sSchemaLocation;
    }

    @Nonnull
    public EChange setSchemaLocation(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sSchemaLocation)) {
            return EChange.UNCHANGED;
        }
        this.m_sSchemaLocation = string;
        return EChange.CHANGED;
    }

    @Nonnull
    public final EChange setUseContextCache(boolean bl) {
        if (bl == this.m_bUseContextCache) {
            return EChange.UNCHANGED;
        }
        this.m_bUseContextCache = bl;
        return EChange.CHANGED;
    }

    public final boolean isUseContextCache() {
        return this.m_bUseContextCache;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final ICommonsList<IReadableResource> getOriginalXSDs() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }

    @Nullable
    @OverrideOnDemand
    protected Schema createValidationSchema() {
        return this.m_aXSDs.isEmpty() ? null : XMLSchemaCache.getInstanceOfClassLoader((ClassLoader)this.m_aClassLoader).getSchema(this.m_aXSDs);
    }

    @Nonnull
    private Unmarshaller _createUnmarshaller(@Nullable ClassLoader classLoader) throws JAXBException {
        Schema schema;
        Package package_ = this.m_aType.getPackage();
        JAXBContext jAXBContext = this.m_bUseContextCache ? JAXBContextCache.getInstance().getFromCache(package_, classLoader) : JAXBContext.newInstance((String)package_.getName(), (ClassLoader)classLoader);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        if (this.m_aVEHFactory != null && (schema = this.m_aVEHFactory.apply(unmarshaller.getEventHandler())) != null) {
            unmarshaller.setEventHandler((ValidationEventHandler)schema);
        }
        if ((schema = this.createValidationSchema()) != null) {
            unmarshaller.setSchema(schema);
        }
        return unmarshaller;
    }

    @OverrideOnDemand
    protected void customizeUnmarshaller(@Nonnull Unmarshaller unmarshaller) {
    }

    @OverrideOnDemand
    protected void handleReadException(@Nonnull JAXBException jAXBException) {
        if (jAXBException instanceof UnmarshalException) {
            Throwable throwable = ((UnmarshalException)jAXBException).getLinkedException();
            if (throwable instanceof SAXParseException) {
                s_aLogger.error("Failed to parse XML document: " + throwable.getMessage());
            } else {
                s_aLogger.error("Unmarshal exception reading document", (Throwable)jAXBException);
            }
        } else {
            s_aLogger.warn("JAXB Exception reading document", (Throwable)jAXBException);
        }
    }

    @Override
    @Nullable
    public final JAXBTYPE read(@Nonnull IJAXBReader.IJAXBUnmarshaller<JAXBTYPE> iJAXBUnmarshaller) {
        ValueEnforcer.notNull(iJAXBUnmarshaller, (String)"Handler");
        try {
            Unmarshaller unmarshaller = this._createUnmarshaller(this.m_aClassLoader);
            this.customizeUnmarshaller(unmarshaller);
            return (JAXBTYPE)iJAXBUnmarshaller.doUnmarshal(unmarshaller, this.m_aType).getValue();
        }
        catch (JAXBException jAXBException) {
            this.handleReadException(jAXBException);
            return null;
        }
    }

    @Nonnull
    private Marshaller _createMarshaller() throws JAXBException {
        Object object;
        Package package_ = this.m_aType.getPackage();
        JAXBContext jAXBContext = this.m_bUseContextCache ? JAXBContextCache.getInstance().getFromCache(package_, this.m_aClassLoader) : JAXBContext.newInstance((String)package_.getName(), (ClassLoader)this.m_aClassLoader);
        Marshaller marshaller = jAXBContext.createMarshaller();
        if (this.m_aVEHFactory != null && (object = this.m_aVEHFactory.apply(marshaller.getEventHandler())) != null) {
            marshaller.setEventHandler(object);
        }
        if (this.m_aNSContext != null) {
            try {
                JAXBMarshallerHelper.setSunNamespacePrefixMapper(marshaller, (NamespaceContext)this.m_aNSContext);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to set the namespace context " + this.m_aNSContext + ": " + throwable.getClass().getName() + " -- " + throwable.getMessage(), GlobalDebug.isDebugMode() ? throwable.getCause() : null);
            }
        }
        JAXBMarshallerHelper.setFormattedOutput(marshaller, this.m_bFormattedOutput);
        if (this.m_aCharset != null) {
            JAXBMarshallerHelper.setEncoding(marshaller, this.m_aCharset);
        }
        if (this.m_sIndentString != null) {
            JAXBMarshallerHelper.setSunIndentString(marshaller, this.m_sIndentString);
        }
        if (this.m_sSchemaLocation != null) {
            JAXBMarshallerHelper.setSchemaLocation(marshaller, this.m_sSchemaLocation);
        }
        if ((object = this.createValidationSchema()) != null) {
            marshaller.setSchema((Schema)object);
        }
        return marshaller;
    }

    @OverrideOnDemand
    protected void customizeMarshaller(@Nonnull Marshaller marshaller) {
    }

    @OverrideOnDemand
    protected void handleWriteException(@Nonnull JAXBException jAXBException) {
        if (jAXBException instanceof MarshalException) {
            s_aLogger.error("Marshal exception writing object", (Throwable)jAXBException);
        } else {
            s_aLogger.warn("JAXB Exception writing object", (Throwable)jAXBException);
        }
    }

    @Override
    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull IJAXBWriter.IJAXBMarshaller<JAXBTYPE> iJAXBMarshaller) {
        ValueEnforcer.notNull(JAXBTYPE, (String)"Object");
        ValueEnforcer.notNull(iJAXBMarshaller, (String)"MarshallerFunc");
        try {
            Marshaller marshaller = this._createMarshaller();
            this.customizeMarshaller(marshaller);
            JAXBElement jAXBElement = (JAXBElement)this.m_aWrapper.apply(JAXBTYPE);
            iJAXBMarshaller.doMarshal(marshaller, jAXBElement);
            return ESuccess.SUCCESS;
        }
        catch (JAXBException jAXBException) {
            this.handleWriteException(jAXBException);
            return ESuccess.FAILURE;
        }
    }
}

