/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.validation;

import com.helger.commons.error.IError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.jaxb.validation.AbstractValidationEventHandler;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LoggingValidationEventHandler
extends AbstractValidationEventHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingValidationEventHandler.class);

    @Override
    protected void onEvent(@Nonnull IError iError) {
        String string = "JAXB " + iError.getAsString(Locale.US);
        if (iError.getErrorLevel().isLE((IErrorLevel)EErrorLevel.WARN)) {
            s_aLogger.warn(string, iError.getLinkedException());
        } else {
            s_aLogger.error(string, iError.getLinkedException());
        }
    }
}

