/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.validation;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.validation.IValidationEventHandler;
import com.helger.xml.serialize.write.XMLWriter;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@NotThreadSafe
public abstract class AbstractValidationEventHandler
implements IValidationEventHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractValidationEventHandler.class);

    @Nonnull
    @OverrideOnDemand
    protected IErrorLevel getErrorLevel(int n) {
        switch (n) {
            case 0: {
                return EErrorLevel.WARN;
            }
            case 1: {
                return EErrorLevel.ERROR;
            }
            case 2: {
                return EErrorLevel.FATAL_ERROR;
            }
        }
        s_aLogger.warn("Unknown JAXB validation severity: " + n + "; defaulting to error");
        return EErrorLevel.ERROR;
    }

    @Nullable
    @OverrideOnDemand
    protected String getLocationResourceID(@Nullable ValidationEventLocator validationEventLocator) {
        URL uRL;
        if (validationEventLocator != null && (uRL = validationEventLocator.getURL()) != null) {
            return uRL.toString();
        }
        return null;
    }

    @Nullable
    @OverrideOnDemand
    protected String getErrorFieldName(@Nullable ValidationEventLocator validationEventLocator) {
        if (validationEventLocator != null) {
            Object object = validationEventLocator.getObject();
            if (object != null) {
                return "obj: " + object.toString();
            }
            Node node = validationEventLocator.getNode();
            if (node != null) {
                return XMLWriter.getNodeAsString((Node)node);
            }
        }
        return null;
    }

    @OverrideOnDemand
    protected abstract void onEvent(@Nonnull IError var1);

    @OverrideOnDemand
    protected boolean continueProcessing(@Nonnull IErrorLevel iErrorLevel) {
        return iErrorLevel.isLT((IErrorLevel)EErrorLevel.FATAL_ERROR);
    }

    public final boolean handleEvent(@Nonnull ValidationEvent validationEvent) {
        IErrorLevel iErrorLevel = this.getErrorLevel(validationEvent.getSeverity());
        SingleError.SingleErrorBuilder singleErrorBuilder = (SingleError.SingleErrorBuilder)SingleError.builder().setErrorLevel(iErrorLevel);
        ValidationEventLocator validationEventLocator = validationEvent.getLocator();
        ((SingleError.SingleErrorBuilder)singleErrorBuilder.setErrorLocation((ILocation)new SimpleLocation(this.getLocationResourceID(validationEventLocator), validationEventLocator != null ? validationEventLocator.getLineNumber() : -1, validationEventLocator != null ? validationEventLocator.getColumnNumber() : -1))).setErrorFieldName(this.getErrorFieldName(validationEventLocator));
        String string = validationEvent.getMessage();
        if (string == null) {
            if (validationEvent.getLinkedException() != null) {
                string = validationEvent.getLinkedException().getMessage();
                if (string == null) {
                    string = "Exception";
                }
            } else {
                string = "Validation event";
            }
        }
        ((SingleError.SingleErrorBuilder)singleErrorBuilder.setErrorText(string)).setLinkedException(validationEvent.getLinkedException());
        this.onEvent((IError)singleErrorBuilder.build());
        return this.continueProcessing(iErrorLevel);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

