/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.xml.schema.XMLSchemaCache;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.validation.Schema;

@NotThreadSafe
public class JAXBDocumentType
implements IJAXBDocumentType {
    private final Class<?> m_aClass;
    private final ICommonsList<ClassPathResource> m_aXSDs = new CommonsArrayList();
    private final String m_sNamespaceURI;
    private final String m_sLocalName;
    private Schema m_aCachedSchema;

    public JAXBDocumentType(@Nonnull Class<?> clazz, @Nullable List<? extends ClassPathResource> list, @Nullable Function<? super String, ? extends String> function) {
        String string;
        String string2;
        Object object2;
        ValueEnforcer.notNull(clazz, (String)"Class");
        if (list != null) {
            ValueEnforcer.notEmptyNoNullValue(list, (String)"XSDs");
            this.m_aXSDs.addAll(list);
        }
        for (Object object2 : this.m_aXSDs) {
            ValueEnforcer.isTrue((boolean)object2.hasClassLoader(), () -> JAXBDocumentType.lambda$new$0((ClassPathResource)object2));
        }
        Iterator iterator = clazz.getAnnotation(XmlType.class);
        if (iterator == null) {
            throw new IllegalArgumentException("The passed class '" + clazz.getName() + "' does not have an @XmlType annotation!");
        }
        object2 = clazz.getPackage();
        XmlSchema xmlSchema = ((Package)object2).getAnnotation(XmlSchema.class);
        if (xmlSchema != null && xmlSchema.namespace() == null) {
            throw new IllegalArgumentException("The package '" + ((Package)object2).getName() + "' has no namespace URI in the @XmlSchema annotation!");
        }
        XmlRootElement xmlRootElement = clazz.getAnnotation(XmlRootElement.class);
        if (xmlRootElement != null) {
            string2 = xmlRootElement.namespace();
            if ("##default".equals(string2) && xmlSchema != null) {
                string2 = xmlSchema.namespace();
            }
            if ("##default".equals(string = xmlRootElement.name())) {
                string = iterator.name();
            }
        } else {
            string2 = xmlSchema != null ? xmlSchema.namespace() : null;
            string = iterator.name();
        }
        if (function != null) {
            string = function.apply(string);
        }
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("Failed to determine the local name of the element to be created!");
        }
        this.m_aClass = clazz;
        this.m_sNamespaceURI = StringHelper.getNotNull((String)string2);
        this.m_sLocalName = string;
    }

    @Override
    @Nonnull
    public Class<?> getImplementationClass() {
        return this.m_aClass;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ClassPathResource> getAllXSDResources() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }

    @Override
    @Nonnull
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLocalName() {
        return this.m_sLocalName;
    }

    @Nullable
    public Schema getSchema() {
        if (this.m_aXSDs.isEmpty()) {
            return null;
        }
        if (this.m_aCachedSchema == null) {
            this.m_aCachedSchema = XMLSchemaCache.getInstance().getSchema(this.m_aXSDs);
        }
        return this.m_aCachedSchema;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JAXBDocumentType jAXBDocumentType = (JAXBDocumentType)object;
        return this.m_aClass.equals(jAXBDocumentType.m_aClass) && this.m_aXSDs.equals(jAXBDocumentType.m_aXSDs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aClass).append(this.m_aXSDs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Class", this.m_aClass).append("XSDPaths", this.m_aXSDs).append("NamespaceURI", (Object)this.m_sNamespaceURI).append("LocalName", (Object)this.m_sLocalName).getToString();
    }

    private static /* synthetic */ String lambda$new$0(ClassPathResource classPathResource) {
        return "ClassPathResource " + classPathResource + " should define its ClassLoader for OSGI handling!";
    }
}

