/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.xml.namespace.INamespaceContext;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.ValidationEventHandler;

@ThreadSafe
public final class JAXBBuilderDefaultSettings {
    public static final boolean DEFAULT_USE_CONTEXT_CACHE = true;
    public static final boolean DEFAULT_FORMATTED_OUTPUT = false;
    public static final Charset DEFAULT_CHARSET = XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bUseContextCache = true;
    @GuardedBy(value="s_aRWLock")
    private static ValidationEventHandler s_aEventHandler;
    @GuardedBy(value="s_aRWLock")
    private static INamespaceContext s_aNamespaceContext;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bFormattedOutput;
    @GuardedBy(value="s_aRWLock")
    private static Charset s_aCharset;
    @GuardedBy(value="s_aRWLock")
    private static String s_sIndentString;
    @GuardedBy(value="s_aRWLock")
    private static String s_sSchemaLocation;
    @GuardedBy(value="s_aRWLock")
    private static String s_sNoNamespaceSchemaLocation;

    private JAXBBuilderDefaultSettings() {
    }

    public static void setDefaultUseContextCache(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bUseContextCache = bl;
            return s_bUseContextCache;
        });
    }

    public static boolean isDefaultUseContextCache() {
        return s_aRWLock.readLocked(() -> s_bUseContextCache);
    }

    public static void setDefaultValidationEventHandler(@Nullable ValidationEventHandler validationEventHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aEventHandler = validationEventHandler;
            return s_aEventHandler;
        });
    }

    @Nullable
    public static ValidationEventHandler getDefaultValidationEventHandler() {
        return (ValidationEventHandler)s_aRWLock.readLocked(() -> s_aEventHandler);
    }

    public static void setDefaultNamespaceContext(@Nullable INamespaceContext iNamespaceContext) {
        s_aRWLock.writeLocked(() -> {
            s_aNamespaceContext = iNamespaceContext;
            return s_aNamespaceContext;
        });
    }

    @Nullable
    public static INamespaceContext getDefaultNamespaceContext() {
        return (INamespaceContext)s_aRWLock.readLocked(() -> s_aNamespaceContext);
    }

    public static void setDefaultFormattedOutput(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bFormattedOutput = bl;
            return s_bFormattedOutput;
        });
    }

    public static boolean isDefaultFormattedOutput() {
        return s_aRWLock.readLocked(() -> s_bFormattedOutput);
    }

    public static void setDefaultCharset(@Nullable Charset charset) {
        s_aRWLock.writeLocked(() -> {
            s_aCharset = charset;
            return s_aCharset;
        });
    }

    @Nullable
    public static Charset getDefaultCharset() {
        return (Charset)s_aRWLock.readLocked(() -> s_aCharset);
    }

    public static void setDefaultIndentString(@Nullable String string) {
        s_aRWLock.writeLocked(() -> {
            s_sIndentString = string;
            return s_sIndentString;
        });
    }

    @Nullable
    public static String getDefaultIndentString() {
        return (String)s_aRWLock.readLocked(() -> s_sIndentString);
    }

    public static void setDefaultSchemaLocation(@Nullable String string) {
        s_aRWLock.writeLocked(() -> {
            s_sSchemaLocation = string;
            return s_sSchemaLocation;
        });
    }

    @Nullable
    public static String getDefaultSchemaLocation() {
        return (String)s_aRWLock.readLocked(() -> s_sSchemaLocation);
    }

    public static void setDefaultNoNamespaceSchemaLocation(@Nullable String string) {
        s_aRWLock.writeLocked(() -> {
            s_sNoNamespaceSchemaLocation = string;
            return s_sNoNamespaceSchemaLocation;
        });
    }

    @Nullable
    public static String getDefaultNoNamespaceSchemaLocation() {
        return (String)s_aRWLock.readLocked(() -> s_sNoNamespaceSchemaLocation);
    }

    static {
        s_bFormattedOutput = false;
        s_aCharset = DEFAULT_CHARSET;
    }
}

