/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsIterable;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.traits.IConvertibleByIndexTrait;
import com.helger.json.IJson;
import com.helger.json.IJsonCollection;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.JsonValue;
import com.helger.json.convert.JsonConverter;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IJsonArray
extends IJsonCollection,
ICommonsIterable<IJson>,
IConvertibleByIndexTrait {
    @Nonnull
    public IJsonArray add(@Nonnull IJson var1);

    @Nonnull
    default public IJsonArray addIf(@Nonnull IJson iJson, @Nonnull Predicate<? super IJson> predicate) {
        if (predicate.test(iJson)) {
            this.add(iJson);
        }
        return this;
    }

    @Nonnull
    default public IJsonArray add(@Nullable Object object) {
        IJson iJson = JsonConverter.convertToJson(object);
        return this.add(iJson);
    }

    @Nonnull
    default public IJsonArray addIfNotNull(@Nullable Object object) {
        if (object != null) {
            this.add(object);
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addIf(@Nullable Object object, @Nonnull Predicate<? super Object> predicate) {
        if (predicate.test(object)) {
            this.add(object);
        }
        return this;
    }

    @Nonnull
    default public IJsonArray add(boolean bl) {
        return this.add(JsonValue.create(bl));
    }

    @Nonnull
    default public IJsonArray add(byte by) {
        return this.add(JsonValue.create(by));
    }

    @Nonnull
    default public IJsonArray add(char c) {
        return this.add(JsonValue.create(c));
    }

    @Nonnull
    default public IJsonArray add(double d) {
        return this.add(JsonValue.create(d));
    }

    @Nonnull
    default public IJsonArray add(float f) {
        return this.add(JsonValue.create(f));
    }

    @Nonnull
    default public IJsonArray add(int n) {
        return this.add(JsonValue.create(n));
    }

    @Nonnull
    default public IJsonArray add(long l) {
        return this.add(JsonValue.create(l));
    }

    @Nonnull
    default public IJsonArray add(short s) {
        return this.add(JsonValue.create(s));
    }

    @Nonnull
    public IJsonArray add(@Nonnegative int var1, @Nonnull IJson var2);

    @Nonnull
    default public IJsonArray add(@Nonnegative int n, @Nullable Object object) {
        IJson iJson = JsonConverter.convertToJson(object);
        return this.add(n, iJson);
    }

    @Nonnull
    default public IJsonArray add(@Nonnegative int n, boolean bl) {
        return this.add(n, JsonValue.create(bl));
    }

    @Nonnull
    default public IJsonArray add(@Nonnegative int n, byte by) {
        return this.add(n, JsonValue.create(by));
    }

    @Nonnull
    default public IJsonArray add(@Nonnegative int n, char c) {
        return this.add(n, JsonValue.create(c));
    }

    @Nonnull
    default public IJsonArray add(@Nonnegative int n, double d) {
        return this.add(n, JsonValue.create(d));
    }

    @Nonnull
    default public IJsonArray add(@Nonnegative int n, float f) {
        return this.add(n, JsonValue.create(f));
    }

    @Nonnull
    default public IJsonArray add(@Nonnegative int n, int n2) {
        return this.add(n, JsonValue.create(n2));
    }

    @Nonnull
    default public IJsonArray add(@Nonnegative int n, long l) {
        return this.add(n, JsonValue.create(l));
    }

    @Nonnull
    default public IJsonArray add(@Nonnegative int n, short s) {
        return this.add(n, JsonValue.create(s));
    }

    @Nonnull
    default public IJsonArray addAll(boolean ... blArray) {
        if (blArray != null) {
            for (boolean bl : blArray) {
                this.add(bl);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(byte ... byArray) {
        if (byArray != null) {
            for (byte by : byArray) {
                this.add(by);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(char ... cArray) {
        if (cArray != null) {
            for (char c : cArray) {
                this.add(c);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(double ... dArray) {
        if (dArray != null) {
            for (double d : dArray) {
                this.add(d);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(float ... fArray) {
        if (fArray != null) {
            for (float f : fArray) {
                this.add(f);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(int ... nArray) {
        if (nArray != null) {
            for (int n : nArray) {
                this.add(n);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(long ... lArray) {
        if (lArray != null) {
            for (long l : lArray) {
                this.add(l);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(short ... sArray) {
        if (sArray != null) {
            for (short s : sArray) {
                this.add(s);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(Object ... objectArray) {
        if (objectArray != null) {
            for (Object object : objectArray) {
                this.add(object);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nullable Iterable<?> iterable) {
        if (iterable != null) {
            for (Object obj : iterable) {
                this.add(obj);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nullable IJsonArray iJsonArray) {
        if (iJsonArray != null) {
            Iterator iterator = iJsonArray.iterator();
            while (iterator.hasNext()) {
                IJson iJson = (IJson)iterator.next();
                this.add(iJson);
            }
        }
        return this;
    }

    @Nonnull
    default public <T> IJsonArray addAllMapped(@Nullable Iterable<? extends T> iterable, @Nonnull Function<? super T, IJson> function) {
        if (iterable != null) {
            for (T t : iterable) {
                this.add(function.apply(t));
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, boolean ... blArray) {
        if (blArray != null) {
            int n2 = n;
            for (boolean bl : blArray) {
                this.add(n2, bl);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, byte ... byArray) {
        if (byArray != null) {
            int n2 = n;
            for (byte by : byArray) {
                this.add(n2, by);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, char ... cArray) {
        if (cArray != null) {
            int n2 = n;
            for (char c : cArray) {
                this.add(n2, c);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, double ... dArray) {
        if (dArray != null) {
            int n2 = n;
            for (double d : dArray) {
                this.add(n2, d);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, float ... fArray) {
        if (fArray != null) {
            int n2 = n;
            for (float f : fArray) {
                this.add(n2, f);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, int ... nArray) {
        if (nArray != null) {
            int n2 = n;
            for (int n3 : nArray) {
                this.add(n2, n3);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, long ... lArray) {
        if (lArray != null) {
            int n2 = n;
            for (long l : lArray) {
                this.add(n2, l);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, short ... sArray) {
        if (sArray != null) {
            int n2 = n;
            for (short s : sArray) {
                this.add(n2, s);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, Object ... objectArray) {
        if (objectArray != null) {
            int n2 = n;
            for (Object object : objectArray) {
                this.add(n2, object);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, @Nullable Iterable<?> iterable) {
        if (iterable != null) {
            int n2 = n;
            for (Object obj : iterable) {
                this.add(n2, obj);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonArray addAll(@Nonnegative int n, @Nullable IJsonArray iJsonArray) {
        if (iJsonArray != null) {
            int n2 = n;
            Iterator iterator = iJsonArray.iterator();
            while (iterator.hasNext()) {
                IJson iJson = (IJson)iterator.next();
                this.add(n2, iJson);
                ++n2;
            }
        }
        return this;
    }

    @Nonnull
    default public <T> IJsonArray addAllMapped(@Nonnegative int n, @Nullable Iterable<? extends T> iterable, @Nonnull Function<? super T, IJson> function) {
        if (iterable != null) {
            int n2 = n;
            for (T t : iterable) {
                this.add(n2, function.apply(t));
                ++n2;
            }
        }
        return this;
    }

    @Nullable
    public IJson removeAndReturnAtIndex(@Nonnegative int var1);

    @Nonnull
    public EChange removeAtIndex(@Nonnegative int var1);

    @Nullable
    public IJson get(@Nonnegative int var1);

    @Nullable
    default public IJsonValue getValueAtIndex(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isValue() ? (IJsonValue)iJson : null;
    }

    @Nullable
    default public IJsonArray getArrayAtIndex(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isArray() ? (IJsonArray)iJson : null;
    }

    @Nullable
    default public IJsonObject getObjectAtIndex(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isObject() ? (IJsonObject)iJson : null;
    }

    @Nullable
    default public Object getValue(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isValue() ? iJson.getAsValue().getValue() : null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public IJsonArray getSubArray(@Nonnegative int var1, @Nonnegative int var2);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJson> getAll();

    public void forEach(@Nonnull ObjIntConsumer<? super IJson> var1);

    public boolean contains(@Nullable IJson var1);

    default public boolean contains(@Nullable Object object) {
        return this.contains(JsonValue.create(object));
    }

    default public boolean contains(boolean bl) {
        return this.contains(JsonValue.create(bl));
    }

    default public boolean contains(byte by) {
        return this.contains(JsonValue.create(by));
    }

    default public boolean contains(char c) {
        return this.contains(JsonValue.create(c));
    }

    default public boolean contains(double d) {
        return this.contains(JsonValue.create(d));
    }

    default public boolean contains(float f) {
        return this.contains(JsonValue.create(f));
    }

    default public boolean contains(int n) {
        return this.contains(JsonValue.create(n));
    }

    default public boolean contains(long l) {
        return this.contains(JsonValue.create(l));
    }

    default public boolean contains(short s) {
        return this.contains(JsonValue.create(s));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJson> getClonedValues();

    @Nonnull
    public IJsonArray getClone();
}

