/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.parser;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.pair.IPair;
import com.helger.commons.collection.pair.Pair;
import com.helger.commons.io.stream.NonBlockingPushbackReader;
import com.helger.commons.string.StringHelper;
import com.helger.json.parser.IJsonParsePosition;
import com.helger.json.parser.JsonParseException;
import com.helger.json.parser.JsonParsePosition;
import com.helger.json.parser.JsonStringBuilder;
import com.helger.json.parser.handler.IJsonParserHandler;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JsonParser {
    public static final int EOI = -1;
    private static final int MAX_PUSH_BACK_CHARS = 2;
    private final NonBlockingPushbackReader m_aReader;
    private final IJsonParserHandler m_aCallback;
    private boolean m_bTrackPosition = false;
    private int m_nTabSize = 8;
    private boolean m_bAlwaysUseBigNumber = false;
    private boolean m_bRequireStringQuotes = true;
    private boolean m_bAllowSpecialCharsInStrings = false;
    private final JsonParsePosition m_aPos = new JsonParsePosition();
    private int m_nBackupChars = 0;

    public JsonParser(@Nonnull @WillNotClose Reader reader, @Nonnull IJsonParserHandler iJsonParserHandler) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)iJsonParserHandler, (String)"Callback");
        this.m_aReader = new NonBlockingPushbackReader(reader, 2);
        this.m_aCallback = iJsonParserHandler;
    }

    public boolean isTrackPosition() {
        return this.m_bTrackPosition;
    }

    @Nonnull
    public JsonParser setTrackPosition(boolean bl) {
        this.m_bTrackPosition = bl;
        return this;
    }

    @Nonnegative
    public int getTabSize() {
        return this.m_nTabSize;
    }

    @Nonnull
    public JsonParser setTabSize(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"TabSize");
        this.m_nTabSize = n;
        return this;
    }

    public boolean isAlwaysUseBigNumber() {
        return this.m_bAlwaysUseBigNumber;
    }

    @Nonnull
    public JsonParser setAlwaysUseBigNumber(boolean bl) {
        this.m_bAlwaysUseBigNumber = bl;
        return this;
    }

    public boolean isRequireStringQuotes() {
        return this.m_bRequireStringQuotes;
    }

    @Nonnull
    public JsonParser setRequireStringQuotes(boolean bl) {
        this.m_bRequireStringQuotes = bl;
        return this;
    }

    public boolean isAllowSpecialCharsInStrings() {
        return this.m_bAllowSpecialCharsInStrings;
    }

    @Nonnull
    public JsonParser setAllowSpecialCharsInStrings(boolean bl) {
        this.m_bAllowSpecialCharsInStrings = bl;
        return this;
    }

    @Nonnegative
    public int getLineNumber() {
        return this.m_aPos.getLineNumber();
    }

    @Nonnegative
    public int getColumn() {
        return this.m_aPos.getColumnNumber();
    }

    private int _readChar() {
        try {
            int n = this.m_aReader.read();
            if (this.m_bTrackPosition) {
                if (this.m_nBackupChars > 0) {
                    --this.m_nBackupChars;
                } else {
                    this.m_aPos.updatePosition(n, this.m_nTabSize);
                }
            }
            return n;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private void _backupChar(int n) throws JsonParseException {
        if (n != -1) {
            try {
                this.m_aReader.unread(n);
                ++this.m_nBackupChars;
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Failed to unread character " + JsonParser._getPrintableChar(n));
            }
        }
    }

    @Nonnull
    private static String _getPrintableChar(int n) {
        if (n == -1) {
            return "<EOI>";
        }
        if (n <= 32) {
            return "0x" + StringHelper.getHexStringLeadingZero((int)n, (int)2);
        }
        if (n >= 127) {
            return "0x" + StringHelper.getHexStringLeadingZero((int)n, (int)4);
        }
        return "'" + (char)n + "'";
    }

    @Nonnull
    private JsonParseException _parseEx(@Nonnull IJsonParsePosition iJsonParsePosition, @Nonnull String string) {
        if (this.m_bTrackPosition) {
            return new JsonParseException(iJsonParsePosition, this.m_aPos, string);
        }
        return new JsonParseException(string);
    }

    private void _readComment() throws JsonParseException {
        JsonParsePosition jsonParsePosition = this.m_aPos.getClone();
        JsonStringBuilder jsonStringBuilder = new JsonStringBuilder(1024);
        while (true) {
            int n;
            if ((n = this._readChar()) == 42) {
                int n2 = this._readChar();
                if (n2 == 47) {
                    this.m_aCallback.onComment(jsonStringBuilder.getAsString());
                    return;
                }
                if (n2 == -1) {
                    throw this._parseEx(jsonParsePosition, "Unclosed JSON comment at end of input");
                }
                this._backupChar(n2);
            }
            if (n == -1) {
                throw this._parseEx(jsonParsePosition, "Unclosed JSON comment at end of input");
            }
            jsonStringBuilder.append((char)n);
        }
    }

    private void _skipSpaces() throws JsonParseException {
        JsonStringBuilder jsonStringBuilder = new JsonStringBuilder();
        while (true) {
            int n;
            if ((n = this._readChar()) == 47) {
                int n2 = this._readChar();
                if (n2 == 42) {
                    if (jsonStringBuilder.hasContent()) {
                        this.m_aCallback.onWhitespace(jsonStringBuilder.getAsString());
                        jsonStringBuilder.reset();
                    }
                    this._readComment();
                    continue;
                }
                this._backupChar(n2);
            }
            if (n != 32 && n != 9 && n != 13 && n != 10 && n != 12) {
                if (jsonStringBuilder.hasContent()) {
                    this.m_aCallback.onWhitespace(jsonStringBuilder.getAsString());
                }
                this._backupChar(n);
                return;
            }
            jsonStringBuilder.append((char)n);
        }
    }

    private int _getHexValue(@Nonnull IJsonParsePosition iJsonParsePosition, int n) throws JsonParseException {
        int n2 = StringHelper.getHexValue((char)((char)n));
        if (n2 == -1) {
            throw this._parseEx(iJsonParsePosition, "Invalid hex character " + JsonParser._getPrintableChar(n) + " provided!");
        }
        return n2;
    }

    private void _readStringEscapeChar(@Nonnull IJsonParsePosition iJsonParsePosition, @Nonnull JsonStringBuilder jsonStringBuilder, @Nonnull JsonStringBuilder jsonStringBuilder2) throws JsonParseException {
        int n = this._readChar();
        jsonStringBuilder.append((char)n);
        if (n == 34 || n == 47 || n == 92) {
            jsonStringBuilder2.append((char)n);
        } else if (n == 98) {
            jsonStringBuilder2.append('\b');
        } else if (n == 102) {
            jsonStringBuilder2.append('\f');
        } else if (n == 110) {
            jsonStringBuilder2.append('\n');
        } else if (n == 114) {
            jsonStringBuilder2.append('\r');
        } else if (n == 116) {
            jsonStringBuilder2.append('\t');
        } else if (n == 117) {
            int n2 = this._readChar();
            int n3 = this._getHexValue(iJsonParsePosition, n2);
            int n4 = this._readChar();
            int n5 = this._getHexValue(iJsonParsePosition, n4);
            int n6 = this._readChar();
            int n7 = this._getHexValue(iJsonParsePosition, n6);
            int n8 = this._readChar();
            int n9 = this._getHexValue(iJsonParsePosition, n8);
            jsonStringBuilder.append((char)n2);
            jsonStringBuilder.append((char)n4);
            jsonStringBuilder.append((char)n6);
            jsonStringBuilder.append((char)n8);
            int n10 = (n3 & 0xFF) << 12 | (n5 & 0xFF) << 8 | (n7 & 0xFF) << 4 | n9 & 0xFF;
            jsonStringBuilder2.append((char)n10);
        } else {
            throw this._parseEx(iJsonParsePosition, "Invalid JSON String escape character " + JsonParser._getPrintableChar(n));
        }
    }

    private static boolean _isUnquotedStringValidChar(int n) {
        return n >= 33 && n <= 122 && n != 58;
    }

    @Nonnull
    private IPair<String, String> _readString(@Nonnull EStringQuoteMode eStringQuoteMode) throws JsonParseException {
        boolean bl;
        JsonParsePosition jsonParsePosition = this.m_aPos.getClone();
        JsonStringBuilder jsonStringBuilder = new JsonStringBuilder(256);
        JsonStringBuilder jsonStringBuilder2 = new JsonStringBuilder(256);
        char c = eStringQuoteMode.getQuoteChar();
        int n = this._readChar();
        boolean bl2 = bl = n == c;
        if (bl) {
            jsonStringBuilder.append(c);
        } else {
            if (this.m_bRequireStringQuotes) {
                throw this._parseEx(jsonParsePosition, "Invalid JSON String start character " + JsonParser._getPrintableChar(n) + " - expected " + JsonParser._getPrintableChar(c));
            }
            this._backupChar(n);
            jsonStringBuilder.append(c);
        }
        block5: while (true) {
            int n2 = this._readChar();
            jsonStringBuilder.append((char)n2);
            switch (n2) {
                case 92: {
                    this._readStringEscapeChar(jsonParsePosition, jsonStringBuilder, jsonStringBuilder2);
                    continue block5;
                }
                case -1: {
                    throw this._parseEx(jsonParsePosition, "Unclosed JSON String at end of input");
                }
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: {
                    if (this.m_bAllowSpecialCharsInStrings) break;
                    throw this._parseEx(jsonParsePosition, "Invalid JSON String character " + JsonParser._getPrintableChar(n2));
                }
            }
            if (bl) {
                if (n2 == c) {
                    break;
                }
            } else if (!JsonParser._isUnquotedStringValidChar(n2)) {
                this._backupChar(n2);
                jsonStringBuilder.backup(1);
                if (jsonStringBuilder2.getLength() == 0) {
                    throw this._parseEx(jsonParsePosition, "Empty unquoted JSON String encountered");
                }
                jsonStringBuilder.append(c);
                break;
            }
            jsonStringBuilder2.append((char)n2);
        }
        return Pair.create((Object)jsonStringBuilder.getAsString(), (Object)jsonStringBuilder2.getAsString());
    }

    @Nonnull
    private static Number _parseNumberInt(@Nonnull JsonStringBuilder jsonStringBuilder) {
        boolean bl;
        boolean bl2;
        int n = jsonStringBuilder.getLength();
        int n2 = 0;
        int n3 = 19;
        boolean bl3 = bl2 = jsonStringBuilder.charAt(0) == '-';
        if (bl2) {
            ++n2;
            ++n3;
        }
        if (n > n3) {
            return jsonStringBuilder.getAsBigInteger();
        }
        if (n < n3) {
            n3 = n;
            bl = false;
        } else {
            n3 = n - 1;
            bl = true;
        }
        long l = 0L;
        while (n2 < n3) {
            l = l * 10L + (long)(48 - jsonStringBuilder.charAt(n2++));
        }
        if (bl) {
            boolean bl4;
            if (l > -922337203685477580L) {
                bl4 = false;
            } else if (l < -922337203685477580L) {
                bl4 = true;
            } else if (bl2) {
                bl4 = jsonStringBuilder.charAt(n2) > '8';
            } else {
                boolean bl5 = bl4 = jsonStringBuilder.charAt(n2) > '7';
            }
            if (bl4) {
                return jsonStringBuilder.getAsBigInteger();
            }
            l = l * 10L + (long)(48 - jsonStringBuilder.charAt(n2));
        }
        if (!bl2) {
            l = -l;
        }
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        return l;
    }

    @Nonnull
    private Number _parseNumber(@Nonnull IJsonParsePosition iJsonParsePosition, boolean bl, boolean bl2, boolean bl3, @Nonnull JsonStringBuilder jsonStringBuilder) throws JsonParseException {
        try {
            int n = jsonStringBuilder.getLength();
            if (bl) {
                if (n > 18 || this.m_bAlwaysUseBigNumber) {
                    return jsonStringBuilder.getAsBigDecimal();
                }
                return jsonStringBuilder.getAsDouble();
            }
            if (bl2) {
                if (bl3) {
                    return jsonStringBuilder.getAsBigDecimal().toBigIntegerExact();
                }
                return jsonStringBuilder.getAsBigDecimal();
            }
            if (this.m_bAlwaysUseBigNumber) {
                return jsonStringBuilder.getAsBigInteger();
            }
            return JsonParser._parseNumberInt(jsonStringBuilder);
        }
        catch (NumberFormatException numberFormatException) {
            throw this._parseEx(iJsonParsePosition, "Invalid JSON Number '" + jsonStringBuilder.getAsString() + "'");
        }
    }

    private void _readNumber() throws JsonParseException {
        boolean bl;
        boolean bl2;
        JsonParsePosition jsonParsePosition = this.m_aPos.getClone();
        JsonStringBuilder jsonStringBuilder = new JsonStringBuilder(32);
        int n = this._readChar();
        if (n == 45) {
            jsonStringBuilder.append((char)n);
            n = this._readChar();
        }
        if (n == 48) {
            jsonStringBuilder.append((char)n);
            n = this._readChar();
        } else if (n >= 49 && n <= 57) {
            jsonStringBuilder.append((char)n);
            n = this._readChar();
            while (n >= 48 && n <= 57) {
                jsonStringBuilder.append((char)n);
                n = this._readChar();
            }
        } else {
            throw this._parseEx(jsonParsePosition, "Invalid JSON Number start character " + JsonParser._getPrintableChar(n));
        }
        boolean bl3 = bl2 = n == 46;
        if (bl2) {
            jsonStringBuilder.append((char)n);
            n = this._readChar();
            bl = false;
            while (n >= 48 && n <= 57) {
                jsonStringBuilder.append((char)n);
                bl = true;
                n = this._readChar();
            }
            if (!bl) {
                throw this._parseEx(jsonParsePosition, "Missing digits after decimal point in JSON Number '" + jsonStringBuilder.getAsString() + "'");
            }
        }
        bl = n == 101 || n == 69;
        boolean bl4 = false;
        if (bl) {
            jsonStringBuilder.append((char)n);
            n = this._readChar();
            boolean bl5 = bl4 = n != 45;
            if (n == 43 || n == 45) {
                jsonStringBuilder.append((char)n);
                n = this._readChar();
            }
            boolean bl6 = false;
            while (n >= 48 && n <= 57) {
                jsonStringBuilder.append((char)n);
                bl6 = true;
                n = this._readChar();
            }
            if (!bl6) {
                throw this._parseEx(jsonParsePosition, "Missing digits after exponent sign in JSON Number '" + jsonStringBuilder.getAsString() + "'");
            }
        }
        this._backupChar(n);
        Number number = this._parseNumber(jsonParsePosition, bl2, bl, bl4, jsonStringBuilder);
        this.m_aCallback.onNumber(jsonStringBuilder.getAsString(), number);
    }

    private void _expect(@Nonnull String string) throws JsonParseException {
        JsonParsePosition jsonParsePosition = this.m_aPos.getClone();
        for (char c : string.toCharArray()) {
            int n = this._readChar();
            if (n == c) continue;
            throw this._parseEx(jsonParsePosition, "Expected " + JsonParser._getPrintableChar(c) + " but got " + JsonParser._getPrintableChar(n) + " as part of JSON keyword \"" + string + "\"");
        }
    }

    private void _readArray() throws JsonParseException {
        block4: {
            int n;
            JsonParsePosition jsonParsePosition = this.m_aPos.getClone();
            this.m_aCallback.onArrayStart();
            int n2 = 0;
            while (true) {
                this._skipSpaces();
                n = this._readChar();
                if (n == 93) {
                    if (n2 != 0) {
                        throw this._parseEx(jsonParsePosition, "Expected another element in JSON Array");
                    }
                    break block4;
                }
                this._backupChar(n);
                this._readValue();
                this._skipSpaces();
                n = this._readChar();
                if (n != 44) break;
                ++n2;
                this.m_aCallback.onArrayNextElement();
            }
            if (n != 93) {
                throw this._parseEx(jsonParsePosition, "Unexpected character " + JsonParser._getPrintableChar(n) + " in JSON array");
            }
        }
        this.m_aCallback.onArrayEnd();
    }

    private void _readObject() throws JsonParseException {
        block5: {
            int n;
            JsonParsePosition jsonParsePosition = this.m_aPos.getClone();
            this.m_aCallback.onObjectStart();
            int n2 = 0;
            while (true) {
                this._skipSpaces();
                n = this._readChar();
                if (n == 125) {
                    if (n2 != 0) {
                        throw this._parseEx(jsonParsePosition, "Expected another element in JSON Object");
                    }
                    break block5;
                }
                EStringQuoteMode eStringQuoteMode = EStringQuoteMode.getFromCharOrDefault(n);
                this._backupChar(n);
                IPair<String, String> iPair = this._readString(eStringQuoteMode);
                this.m_aCallback.onObjectName((String)iPair.getFirst(), (String)iPair.getSecond());
                this._skipSpaces();
                n = this._readChar();
                if (n != 58) {
                    throw this._parseEx(jsonParsePosition, "Expected colon character in JSON Object but found " + JsonParser._getPrintableChar(n));
                }
                this.m_aCallback.onObjectColon();
                this._skipSpaces();
                this._readValue();
                this._skipSpaces();
                n = this._readChar();
                if (n != 44) break;
                ++n2;
                this.m_aCallback.onObjectNextElement();
            }
            if (n != 125) {
                throw this._parseEx(jsonParsePosition, "Unexpected character " + JsonParser._getPrintableChar(n) + " in JSON Object");
            }
        }
        this.m_aCallback.onObjectEnd();
    }

    private void _readValue() throws JsonParseException {
        this._skipSpaces();
        JsonParsePosition jsonParsePosition = this.m_aPos.getClone();
        int n = this._readChar();
        switch (n) {
            case 39: {
                this._backupChar(n);
                IPair<String, String> iPair = this._readString(EStringQuoteMode.SINGLE);
                this.m_aCallback.onString((String)iPair.getFirst(), (String)iPair.getSecond());
                break;
            }
            case 34: {
                this._backupChar(n);
                IPair<String, String> iPair = this._readString(EStringQuoteMode.DOUBLE);
                this.m_aCallback.onString((String)iPair.getFirst(), (String)iPair.getSecond());
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._backupChar(n);
                this._readNumber();
                break;
            }
            case 116: {
                this._backupChar(n);
                this._expect("true");
                this.m_aCallback.onTrue();
                break;
            }
            case 102: {
                this._backupChar(n);
                this._expect("false");
                this.m_aCallback.onFalse();
                break;
            }
            case 110: {
                this._backupChar(n);
                this._expect("null");
                this.m_aCallback.onNull();
                break;
            }
            case 91: {
                this._readArray();
                break;
            }
            case 123: {
                this._readObject();
                break;
            }
            default: {
                throw this._parseEx(jsonParsePosition, "Syntax error in JSON. Found " + JsonParser._getPrintableChar(n));
            }
        }
    }

    public void parse() throws JsonParseException {
        this._readValue();
        this._skipSpaces();
        JsonParsePosition jsonParsePosition = this.m_aPos.getClone();
        int n = this._readChar();
        if (n != -1) {
            throw this._parseEx(jsonParsePosition, "Invalid character " + JsonParser._getPrintableChar(n) + " after JSON root object");
        }
    }

    private static enum EStringQuoteMode {
        DOUBLE('\"'),
        SINGLE('\'');

        private char m_cQuote;

        private EStringQuoteMode(char c) {
            this.m_cQuote = c;
        }

        public char getQuoteChar() {
            return this.m_cQuote;
        }

        @Nonnull
        public static EStringQuoteMode getFromCharOrDefault(int n) {
            if (n == 39) {
                return SINGLE;
            }
            return DOUBLE;
        }
    }
}

