/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.serialize;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.EUnicodeBOM;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.stream.NonBlockingPushbackInputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.state.EValidity;
import com.helger.json.IJson;
import com.helger.json.parser.IJsonParserCustomizeCallback;
import com.helger.json.parser.JsonParseException;
import com.helger.json.parser.JsonParser;
import com.helger.json.parser.errorhandler.IJsonParseExceptionCallback;
import com.helger.json.parser.errorhandler.LoggingJsonParseExceptionCallback;
import com.helger.json.parser.handler.CollectingJsonParserHandler;
import com.helger.json.parser.handler.DoNothingJsonParserHandler;
import com.helger.json.parser.handler.IJsonParserHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JsonReader {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Logger s_aLogger = LoggerFactory.getLogger(JsonReader.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IJsonParseExceptionCallback s_aDefaultParseExceptionCallback = new LoggingJsonParseExceptionCallback();
    private static final JsonReader s_aInstance = new JsonReader();

    private JsonReader() {
    }

    @Nonnull
    public static IJsonParseExceptionCallback getDefaultParseExceptionCallback() {
        return (IJsonParseExceptionCallback)s_aRWLock.readLocked(() -> s_aDefaultParseExceptionCallback);
    }

    public static void setDefaultParseExceptionCallback(@Nonnull IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull((Object)iJsonParseExceptionCallback, (String)"DefaultParseExceptionCallback");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseExceptionCallback = iJsonParseExceptionCallback;
        });
    }

    @Nonnull
    public static ESuccess parseJson(@Nonnull @WillClose Reader reader, @Nonnull IJsonParserHandler iJsonParserHandler) {
        return JsonReader.parseJson(reader, iJsonParserHandler, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess parseJson(@Nonnull @WillClose Reader reader, @Nonnull IJsonParserHandler iJsonParserHandler, @Nullable IJsonParserCustomizeCallback iJsonParserCustomizeCallback, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)iJsonParserHandler, (String)"ParserHandler");
        try {
            JsonParser jsonParser = new JsonParser(reader, iJsonParserHandler);
            if (iJsonParserCustomizeCallback != null) {
                iJsonParserCustomizeCallback.customizeJsonParser(jsonParser);
            }
            jsonParser.parse();
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (JsonParseException jsonParseException) {
            if (iJsonParseExceptionCallback != null) {
                iJsonParseExceptionCallback.onException(jsonParseException);
            } else {
                JsonReader.getDefaultParseExceptionCallback().onException(jsonParseException);
            }
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    @Nonnull
    private static EValidity _validateJson(@Nonnull @WillClose Reader reader) {
        ESuccess eSuccess = JsonReader.parseJson(reader, new DoNothingJsonParserHandler(), null, (IJsonParseExceptionCallback & Serializable)jsonParseException -> {});
        return EValidity.valueOf((boolean)eSuccess.isSuccess());
    }

    public static boolean isValidJson(@Nonnull File file) {
        return JsonReader.isValidJson(file, DEFAULT_CHARSET);
    }

    public static boolean isValidJson(@Nonnull File file, @Nonnull Charset charset) {
        return JsonReader.isValidJson((IHasInputStream)new FileSystemResource(file), charset);
    }

    public static boolean isValidJson(@Nonnull Path path) {
        return JsonReader.isValidJson(path, DEFAULT_CHARSET);
    }

    public static boolean isValidJson(@Nonnull Path path, @Nonnull Charset charset) {
        return JsonReader.isValidJson((IHasInputStream)new FileSystemResource(path), charset);
    }

    public static boolean isValidJson(@Nonnull IHasInputStream iHasInputStream) {
        return JsonReader.isValidJson(iHasInputStream, DEFAULT_CHARSET);
    }

    public static boolean isValidJson(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            s_aLogger.warn("Failed to open Json InputStream from " + iHasInputStream);
            return false;
        }
        return JsonReader.isValidJson(inputStream, charset);
    }

    public static boolean isValidJson(@Nonnull @WillClose InputStream inputStream) {
        return JsonReader.isValidJson(inputStream, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidJson(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        InputStreamAndCharset inputStreamAndCharset = JsonReader._getInputStreamWithoutBOM(inputStream);
        if (inputStreamAndCharset == null || !inputStreamAndCharset.hasInputStream()) {
            return false;
        }
        InputStream inputStream2 = inputStreamAndCharset.getInputStream();
        Charset charset2 = inputStreamAndCharset.getCharset() != null ? inputStreamAndCharset.getCharset() : charset;
        try {
            Reader reader = StreamHelper.getBuffered((Reader)StreamHelper.createReader((InputStream)inputStream2, (Charset)charset2));
            boolean bl = JsonReader.isValidJson(reader);
            return bl;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream2);
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    public static boolean isValidJson(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Json");
        return JsonReader.isValidJson((Reader)new NonBlockingStringReader(string));
    }

    public static boolean isValidJson(@Nonnull @WillClose Reader reader) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        return JsonReader._validateJson(StreamHelper.getBuffered((Reader)reader)).isValid();
    }

    @Nullable
    private static IJson _readJson(@Nonnull @WillClose Reader reader, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        CollectingJsonParserHandler collectingJsonParserHandler = new CollectingJsonParserHandler();
        if (JsonReader.parseJson(reader, collectingJsonParserHandler, null, iJsonParseExceptionCallback).isFailure()) {
            return null;
        }
        return collectingJsonParserHandler.getJson();
    }

    @Nullable
    public static IJson readFromString(@Nonnull String string) {
        return JsonReader.readFromReader((Reader)new NonBlockingStringReader(string), null);
    }

    @Nullable
    public static IJson readFromString(@Nonnull String string, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        return JsonReader.readFromReader((Reader)new NonBlockingStringReader(string), iJsonParseExceptionCallback);
    }

    @Nullable
    public static IJson readFromFile(@Nonnull File file) {
        return JsonReader.readFromFile(file, DEFAULT_CHARSET);
    }

    @Nullable
    public static IJson readFromFile(@Nonnull File file, @Nonnull Charset charset) {
        return JsonReader.readFromFile(file, charset, null);
    }

    @Nullable
    public static IJson readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        return JsonReader.readFromStream((IHasInputStream)new FileSystemResource(file), charset, iJsonParseExceptionCallback);
    }

    @Nullable
    public static IJson readFromPath(@Nonnull Path path) {
        return JsonReader.readFromPath(path, DEFAULT_CHARSET);
    }

    @Nullable
    public static IJson readFromPath(@Nonnull Path path, @Nonnull Charset charset) {
        return JsonReader.readFromPath(path, charset, null);
    }

    @Nullable
    public static IJson readFromPath(@Nonnull Path path, @Nonnull Charset charset, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        return JsonReader.readFromStream((IHasInputStream)new FileSystemResource(path), charset, iJsonParseExceptionCallback);
    }

    @Nullable
    public static IJson readFromStream(@Nonnull IHasInputStream iHasInputStream) {
        return JsonReader.readFromStream(iHasInputStream, DEFAULT_CHARSET);
    }

    @Nullable
    public static IJson readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset) {
        return JsonReader.readFromStream(iHasInputStream, charset, null);
    }

    @Nullable
    public static IJson readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return JsonReader.readFromStream(inputStream, charset, iJsonParseExceptionCallback);
    }

    @Nullable
    public static IJson readFromStream(@Nonnull InputStream inputStream) {
        return JsonReader.readFromStream(inputStream, DEFAULT_CHARSET);
    }

    @Nullable
    public static IJson readFromStream(@Nonnull InputStream inputStream, @Nonnull Charset charset) {
        return JsonReader.readFromStream(inputStream, charset, null);
    }

    @Nullable
    private static InputStreamAndCharset _getInputStreamWithoutBOM(@Nonnull InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        int n = EUnicodeBOM.getMaximumByteCount();
        NonBlockingPushbackInputStream nonBlockingPushbackInputStream = new NonBlockingPushbackInputStream(inputStream, n);
        try {
            byte[] byArray = new byte[n];
            int n2 = nonBlockingPushbackInputStream.read(byArray);
            Charset charset = null;
            if (n2 > 0) {
                EUnicodeBOM eUnicodeBOM = EUnicodeBOM.getFromBytesOrNull((byte[])ArrayHelper.getCopy((byte[])byArray, (int)0, (int)n2));
                if (eUnicodeBOM == null) {
                    nonBlockingPushbackInputStream.unread(byArray, 0, n2);
                } else {
                    int n3 = eUnicodeBOM.getByteCount();
                    if (n3 < n2) {
                        nonBlockingPushbackInputStream.unread(byArray, n3, n2 - n3);
                    }
                    charset = eUnicodeBOM.getCharset();
                }
            }
            return new InputStreamAndCharset((InputStream)nonBlockingPushbackInputStream, charset);
        }
        catch (IOException iOException) {
            s_aLogger.error("Failed to determine BOM", (Throwable)iOException);
            StreamHelper.close((AutoCloseable)nonBlockingPushbackInputStream);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IJson readFromStream(@Nonnull InputStream inputStream, @Nonnull Charset charset, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        InputStreamAndCharset inputStreamAndCharset = JsonReader._getInputStreamWithoutBOM(inputStream);
        if (inputStreamAndCharset == null || !inputStreamAndCharset.hasInputStream()) {
            return null;
        }
        InputStream inputStream2 = inputStreamAndCharset.getInputStream();
        Charset charset2 = inputStreamAndCharset.getCharset() != null ? inputStreamAndCharset.getCharset() : charset;
        try {
            Reader reader = StreamHelper.getBuffered((Reader)StreamHelper.createReader((InputStream)inputStream2, (Charset)charset2));
            IJson iJson = JsonReader._readJson(reader, iJsonParseExceptionCallback);
            return iJson;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream2);
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nullable
    public static IJson readFromReader(@Nonnull Reader reader) {
        return JsonReader.readFromReader(reader, null);
    }

    @Nullable
    public static IJson readFromReader(@Nonnull Reader reader, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        return JsonReader._readJson(StreamHelper.getBuffered((Reader)reader), iJsonParseExceptionCallback);
    }

    private static final class InputStreamAndCharset
    implements IHasInputStream {
        private final InputStream m_aIS;
        private final Charset m_aCharset;

        public InputStreamAndCharset(@Nullable InputStream inputStream, @Nullable Charset charset) {
            this.m_aIS = inputStream;
            this.m_aCharset = charset;
        }

        @Nullable
        public InputStream getInputStream() {
            return this.m_aIS;
        }

        public boolean hasInputStream() {
            return this.m_aIS != null;
        }

        @Nullable
        public Charset getCharset() {
            return this.m_aCharset;
        }
    }
}

