/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.valueserializer;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.json.valueserializer.IJsonValueSerializer;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public final class JsonValueSerializerTypeConverterToString
implements IJsonValueSerializer {
    private static final JsonValueSerializerTypeConverterToString s_aInstance = new JsonValueSerializerTypeConverterToString();

    private JsonValueSerializerTypeConverterToString() {
    }

    @Nonnull
    public static JsonValueSerializerTypeConverterToString getInstance() {
        return s_aInstance;
    }

    @Override
    public void appendAsJsonString(@Nullable Object object, @Nonnull @WillNotClose Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        String string = (String)TypeConverter.convertIfNecessary((Object)object, String.class);
        writer.write(string);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

