/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.valueserializer;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.json.valueserializer.IJsonValueSerializer;
import com.helger.json.valueserializer.JsonValueSerializerEscaped;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public final class JsonValueSerializerTypeConverterToStringEscaped
implements IJsonValueSerializer {
    private static final JsonValueSerializerTypeConverterToStringEscaped s_aInstance = new JsonValueSerializerTypeConverterToStringEscaped();

    private JsonValueSerializerTypeConverterToStringEscaped() {
    }

    @Nonnull
    public static JsonValueSerializerTypeConverterToStringEscaped getInstance() {
        return s_aInstance;
    }

    @Override
    public void appendAsJsonString(@Nullable Object object, @Nonnull @WillNotClose Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        String string = (String)TypeConverter.convertIfNecessary((Object)object, String.class);
        JsonValueSerializerEscaped.appendEscapedJsonString(string, writer);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

