/*
 * Decompiled with CFR 0.152.
 */
package com.helger.matrix;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.math.MathHelper;
import com.helger.matrix.Matrix;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class EigenvalueDecomposition
implements Serializable {
    private static final double EPSILON = Math.pow(2.0, -52.0);
    private final int m_nDim;
    private final boolean m_bIsSymmetric;
    private final double[] m_aEVd;
    private final double[] m_aEVe;
    private final double[][] m_aEigenVector;
    private double[][] m_aHessenBerg;
    private double[] m_aOrt;
    private double m_dCdivr;
    private double m_dCdivi;

    private void _symmetricTred2() {
        double d;
        int n;
        for (n = 0; n < this.m_nDim; ++n) {
            this.m_aEVd[n] = this.m_aEigenVector[this.m_nDim - 1][n];
        }
        for (n = this.m_nDim - 1; n > 0; --n) {
            int n2;
            d = 0.0;
            double d2 = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += MathHelper.abs((double)this.m_aEVd[n2]);
            }
            if (d == 0.0) {
                this.m_aEVe[n] = this.m_aEVd[n - 1];
                for (n2 = 0; n2 < n; ++n2) {
                    this.m_aEVd[n2] = this.m_aEigenVector[n - 1][n2];
                    this.m_aEigenVector[n][n2] = 0.0;
                    this.m_aEigenVector[n2][n] = 0.0;
                }
            } else {
                int n3;
                int n4;
                for (n2 = 0; n2 < n; ++n2) {
                    int n5 = n2;
                    this.m_aEVd[n5] = this.m_aEVd[n5] / d;
                    d2 += this.m_aEVd[n2] * this.m_aEVd[n2];
                }
                double d3 = this.m_aEVd[n - 1];
                double d4 = Math.sqrt(d2);
                if (d3 > 0.0) {
                    d4 = -d4;
                }
                this.m_aEVe[n] = d * d4;
                d2 -= d3 * d4;
                this.m_aEVd[n - 1] = d3 - d4;
                for (n4 = 0; n4 < n; ++n4) {
                    this.m_aEVe[n4] = 0.0;
                }
                for (n4 = 0; n4 < n; ++n4) {
                    this.m_aEigenVector[n4][n] = d3 = this.m_aEVd[n4];
                    d4 = this.m_aEVe[n4] + this.m_aEigenVector[n4][n4] * d3;
                    for (int i = n4 + 1; i <= n - 1; ++i) {
                        d4 += this.m_aEigenVector[i][n4] * this.m_aEVd[i];
                        int n6 = i;
                        this.m_aEVe[n6] = this.m_aEVe[n6] + this.m_aEigenVector[i][n4] * d3;
                    }
                    this.m_aEVe[n4] = d4;
                }
                d3 = 0.0;
                for (n4 = 0; n4 < n; ++n4) {
                    int n7 = n4;
                    this.m_aEVe[n7] = this.m_aEVe[n7] / d2;
                    d3 += this.m_aEVe[n4] * this.m_aEVd[n4];
                }
                double d5 = d3 / (d2 + d2);
                for (n3 = 0; n3 < n; ++n3) {
                    int n8 = n3;
                    this.m_aEVe[n8] = this.m_aEVe[n8] - d5 * this.m_aEVd[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    d3 = this.m_aEVd[n3];
                    d4 = this.m_aEVe[n3];
                    for (int i = n3; i <= n - 1; ++i) {
                        double[] dArray = this.m_aEigenVector[i];
                        int n9 = n3;
                        dArray[n9] = dArray[n9] - (d3 * this.m_aEVe[i] + d4 * this.m_aEVd[i]);
                    }
                    this.m_aEVd[n3] = this.m_aEigenVector[n - 1][n3];
                    this.m_aEigenVector[n][n3] = 0.0;
                }
            }
            this.m_aEVd[n] = d2;
        }
        for (n = 0; n < this.m_nDim - 1; ++n) {
            int n10;
            this.m_aEigenVector[this.m_nDim - 1][n] = this.m_aEigenVector[n][n];
            this.m_aEigenVector[n][n] = 1.0;
            d = this.m_aEVd[n + 1];
            if (d != 0.0) {
                for (n10 = 0; n10 <= n; ++n10) {
                    this.m_aEVd[n10] = this.m_aEigenVector[n10][n + 1] / d;
                }
                for (n10 = 0; n10 <= n; ++n10) {
                    int n11;
                    double d6 = 0.0;
                    for (n11 = 0; n11 <= n; ++n11) {
                        d6 += this.m_aEigenVector[n11][n + 1] * this.m_aEigenVector[n11][n10];
                    }
                    for (n11 = 0; n11 <= n; ++n11) {
                        double[] dArray = this.m_aEigenVector[n11];
                        int n12 = n10;
                        dArray[n12] = dArray[n12] - d6 * this.m_aEVd[n11];
                    }
                }
            }
            for (n10 = 0; n10 <= n; ++n10) {
                this.m_aEigenVector[n10][n + 1] = 0.0;
            }
        }
        for (n = 0; n < this.m_nDim; ++n) {
            this.m_aEVd[n] = this.m_aEigenVector[this.m_nDim - 1][n];
            this.m_aEigenVector[this.m_nDim - 1][n] = 0.0;
        }
        this.m_aEigenVector[this.m_nDim - 1][this.m_nDim - 1] = 1.0;
        this.m_aEVe[0] = 0.0;
    }

    private void _symmetricTql2() {
        double d;
        int n;
        int n2;
        for (int i = 1; i < this.m_nDim; ++i) {
            this.m_aEVe[i - 1] = this.m_aEVe[i];
        }
        this.m_aEVe[this.m_nDim - 1] = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n2 = 0; n2 < this.m_nDim; ++n2) {
            d3 = Math.max(d3, MathHelper.abs((double)this.m_aEVd[n2]) + MathHelper.abs((double)this.m_aEVe[n2]));
            for (n = n2; n < this.m_nDim && !(MathHelper.abs((double)this.m_aEVe[n]) <= EPSILON * d3); ++n) {
            }
            if (n > n2) {
                do {
                    double d4;
                    d = this.m_aEVd[n2];
                    double d5 = (this.m_aEVd[n2 + 1] - d) / (2.0 * this.m_aEVe[n2]);
                    double d6 = MathHelper.hypot((double)d5, (double)1.0);
                    if (d5 < 0.0) {
                        d6 = -d6;
                    }
                    this.m_aEVd[n2] = this.m_aEVe[n2] / (d5 + d6);
                    this.m_aEVd[n2 + 1] = this.m_aEVe[n2] * (d5 + d6);
                    double d7 = this.m_aEVd[n2 + 1];
                    double d8 = d - this.m_aEVd[n2];
                    int n3 = n2 + 2;
                    while (n3 < this.m_nDim) {
                        int n4 = n3++;
                        this.m_aEVd[n4] = this.m_aEVd[n4] - d8;
                    }
                    d2 += d8;
                    d5 = this.m_aEVd[n];
                    double d9 = d4 = 1.0;
                    double d10 = d4;
                    double d11 = this.m_aEVe[n2 + 1];
                    double d12 = 0.0;
                    double d13 = 0.0;
                    for (int i = n - 1; i >= n2; --i) {
                        d10 = d9;
                        d9 = d4;
                        d13 = d12;
                        d = d4 * this.m_aEVe[i];
                        d8 = d4 * d5;
                        d6 = MathHelper.hypot((double)d5, (double)this.m_aEVe[i]);
                        this.m_aEVe[i + 1] = d12 * d6;
                        d12 = this.m_aEVe[i] / d6;
                        d4 = d5 / d6;
                        d5 = d4 * this.m_aEVd[i] - d12 * d;
                        this.m_aEVd[i + 1] = d8 + d12 * (d4 * d + d12 * this.m_aEVd[i]);
                        for (int j = 0; j < this.m_nDim; ++j) {
                            d8 = this.m_aEigenVector[j][i + 1];
                            this.m_aEigenVector[j][i + 1] = d12 * this.m_aEigenVector[j][i] + d4 * d8;
                            this.m_aEigenVector[j][i] = d4 * this.m_aEigenVector[j][i] - d12 * d8;
                        }
                    }
                    d5 = -d12 * d13 * d10 * d11 * this.m_aEVe[n2] / d7;
                    this.m_aEVe[n2] = d12 * d5;
                    this.m_aEVd[n2] = d4 * d5;
                } while (MathHelper.abs((double)this.m_aEVe[n2]) > EPSILON * d3);
            }
            this.m_aEVd[n2] = this.m_aEVd[n2] + d2;
            this.m_aEVe[n2] = 0.0;
        }
        for (n2 = 0; n2 < this.m_nDim - 1; ++n2) {
            int n5;
            n = n2;
            d = this.m_aEVd[n2];
            for (n5 = n2 + 1; n5 < this.m_nDim; ++n5) {
                if (!(this.m_aEVd[n5] < d)) continue;
                n = n5;
                d = this.m_aEVd[n5];
            }
            if (n == n2) continue;
            this.m_aEVd[n] = this.m_aEVd[n2];
            this.m_aEVd[n2] = d;
            for (n5 = 0; n5 < this.m_nDim; ++n5) {
                d = this.m_aEigenVector[n5][n2];
                this.m_aEigenVector[n5][n2] = this.m_aEigenVector[n5][n];
                this.m_aEigenVector[n5][n] = d;
            }
        }
    }

    private void _nonsymetricOrthes() {
        int n;
        int n2 = this.m_nDim - 1;
        for (n = 1; n <= n2 - 1; ++n) {
            int n3;
            double d;
            int n4;
            double d2 = 0.0;
            for (int i = n; i <= n2; ++i) {
                d2 += MathHelper.abs((double)this.m_aHessenBerg[i][n - 1]);
            }
            if (d2 == 0.0) continue;
            double d3 = 0.0;
            for (int i = n2; i >= n; --i) {
                this.m_aOrt[i] = this.m_aHessenBerg[i][n - 1] / d2;
                d3 += this.m_aOrt[i] * this.m_aOrt[i];
            }
            double d4 = Math.sqrt(d3);
            if (this.m_aOrt[n] > 0.0) {
                d4 = -d4;
            }
            d3 -= this.m_aOrt[n] * d4;
            this.m_aOrt[n] = this.m_aOrt[n] - d4;
            for (n4 = n; n4 < this.m_nDim; ++n4) {
                d = 0.0;
                for (n3 = n2; n3 >= n; --n3) {
                    d += this.m_aOrt[n3] * this.m_aHessenBerg[n3][n4];
                }
                d /= d3;
                for (n3 = n; n3 <= n2; ++n3) {
                    double[] dArray = this.m_aHessenBerg[n3];
                    int n5 = n4;
                    dArray[n5] = dArray[n5] - d * this.m_aOrt[n3];
                }
            }
            for (n4 = 0; n4 <= n2; ++n4) {
                d = 0.0;
                for (n3 = n2; n3 >= n; --n3) {
                    d += this.m_aOrt[n3] * this.m_aHessenBerg[n4][n3];
                }
                d /= d3;
                for (n3 = n; n3 <= n2; ++n3) {
                    double[] dArray = this.m_aHessenBerg[n4];
                    int n6 = n3;
                    dArray[n6] = dArray[n6] - d * this.m_aOrt[n3];
                }
            }
            this.m_aOrt[n] = d2 * this.m_aOrt[n];
            this.m_aHessenBerg[n][n - 1] = d2 * d4;
        }
        for (n = 0; n < this.m_nDim; ++n) {
            double[] dArray = this.m_aEigenVector[n];
            for (int i = 0; i < this.m_nDim; ++i) {
                dArray[i] = n == i ? 1.0 : 0.0;
            }
        }
        for (n = n2 - 1; n >= 1; --n) {
            int n7;
            if (this.m_aHessenBerg[n][n - 1] == 0.0) continue;
            for (n7 = n + 1; n7 <= n2; ++n7) {
                this.m_aOrt[n7] = this.m_aHessenBerg[n7][n - 1];
            }
            for (n7 = n; n7 <= n2; ++n7) {
                int n8;
                double d = 0.0;
                for (n8 = n; n8 <= n2; ++n8) {
                    d += this.m_aOrt[n8] * this.m_aEigenVector[n8][n7];
                }
                d = d / this.m_aOrt[n] / this.m_aHessenBerg[n][n - 1];
                for (n8 = n; n8 <= n2; ++n8) {
                    double[] dArray = this.m_aEigenVector[n8];
                    int n9 = n7;
                    dArray[n9] = dArray[n9] + d * this.m_aOrt[n8];
                }
            }
        }
    }

    private void _cdiv(double d, double d2, double d3, double d4) {
        if (MathHelper.abs((double)d3) > MathHelper.abs((double)d4)) {
            double d5 = d3 == 0.0 ? 0.0 : d4 / d3;
            double d6 = d3 + d5 * d4;
            if (d6 == 0.0) {
                this.m_dCdivr = 0.0;
                this.m_dCdivi = 0.0;
            } else {
                this.m_dCdivr = (d + d5 * d2) / d6;
                this.m_dCdivi = (d2 - d5 * d) / d6;
            }
        } else {
            double d7 = d4 == 0.0 ? 0.0 : d3 / d4;
            double d8 = d4 + d7 * d3;
            if (d8 == 0.0) {
                this.m_dCdivr = 0.0;
                this.m_dCdivi = 0.0;
            } else {
                this.m_dCdivr = (d7 * d + d2) / d8;
                this.m_dCdivi = (d7 * d2 - d) / d8;
            }
        }
    }

    private void _nonsymetricHqr2() {
        double d;
        int n;
        double d2;
        double d3;
        int n2;
        int n3;
        int n4 = this.m_nDim;
        int n5 = n4 - 1;
        int n6 = n4 - 1;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (n3 < 0 || n3 > n6) {
                this.m_aEVd[n3] = this.m_aHessenBerg[n3][n3];
                this.m_aEVe[n3] = 0.0;
            }
            for (n2 = Math.max(n3 - 1, 0); n2 < n4; ++n2) {
                d10 += MathHelper.abs((double)this.m_aHessenBerg[n3][n2]);
            }
        }
        n3 = 0;
        while (n5 >= 0) {
            int n7;
            for (n2 = n5; n2 > 0; --n2) {
                d8 = MathHelper.abs((double)this.m_aHessenBerg[n2 - 1][n2 - 1]) + MathHelper.abs((double)this.m_aHessenBerg[n2][n2]);
                if (d8 == 0.0) {
                    d8 = d10;
                }
                if (MathHelper.abs((double)this.m_aHessenBerg[n2][n2 - 1]) < EPSILON * d8) break;
            }
            if (n2 == n5) {
                this.m_aHessenBerg[n5][n5] = this.m_aHessenBerg[n5][n5] + d4;
                this.m_aEVd[n5] = this.m_aHessenBerg[n5][n5];
                this.m_aEVe[n5] = 0.0;
                --n5;
                n3 = 0;
                continue;
            }
            if (n2 == n5 - 1) {
                d3 = this.m_aHessenBerg[n5][n5 - 1] * this.m_aHessenBerg[n5 - 1][n5];
                d5 = (this.m_aHessenBerg[n5 - 1][n5 - 1] - this.m_aHessenBerg[n5][n5]) / 2.0;
                d6 = d5 * d5 + d3;
                d9 = Math.sqrt(MathHelper.abs((double)d6));
                this.m_aHessenBerg[n5][n5] = this.m_aHessenBerg[n5][n5] + d4;
                this.m_aHessenBerg[n5 - 1][n5 - 1] = this.m_aHessenBerg[n5 - 1][n5 - 1] + d4;
                d2 = this.m_aHessenBerg[n5][n5];
                if (d6 >= 0.0) {
                    d9 = d5 >= 0.0 ? d5 + d9 : d5 - d9;
                    this.m_aEVd[n5 - 1] = d2 + d9;
                    this.m_aEVd[n5] = this.m_aEVd[n5 - 1];
                    if (d9 != 0.0) {
                        this.m_aEVd[n5] = d2 - d3 / d9;
                    }
                    this.m_aEVe[n5 - 1] = 0.0;
                    this.m_aEVe[n5] = 0.0;
                    d2 = this.m_aHessenBerg[n5][n5 - 1];
                    d8 = MathHelper.abs((double)d2) + MathHelper.abs((double)d9);
                    d5 = d2 / d8;
                    d6 = d9 / d8;
                    d7 = Math.sqrt(d5 * d5 + d6 * d6);
                    d5 /= d7;
                    d6 /= d7;
                    for (n = n5 - 1; n < n4; ++n) {
                        d9 = this.m_aHessenBerg[n5 - 1][n];
                        this.m_aHessenBerg[n5 - 1][n] = d6 * d9 + d5 * this.m_aHessenBerg[n5][n];
                        this.m_aHessenBerg[n5][n] = d6 * this.m_aHessenBerg[n5][n] - d5 * d9;
                    }
                    for (n = 0; n <= n5; ++n) {
                        d9 = this.m_aHessenBerg[n][n5 - 1];
                        this.m_aHessenBerg[n][n5 - 1] = d6 * d9 + d5 * this.m_aHessenBerg[n][n5];
                        this.m_aHessenBerg[n][n5] = d6 * this.m_aHessenBerg[n][n5] - d5 * d9;
                    }
                    for (n = 0; n <= n6; ++n) {
                        d9 = this.m_aEigenVector[n][n5 - 1];
                        this.m_aEigenVector[n][n5 - 1] = d6 * d9 + d5 * this.m_aEigenVector[n][n5];
                        this.m_aEigenVector[n][n5] = d6 * this.m_aEigenVector[n][n5] - d5 * d9;
                    }
                } else {
                    this.m_aEVd[n5 - 1] = d2 + d5;
                    this.m_aEVd[n5] = d2 + d5;
                    this.m_aEVe[n5 - 1] = d9;
                    this.m_aEVe[n5] = -d9;
                }
                n5 -= 2;
                n3 = 0;
                continue;
            }
            d2 = this.m_aHessenBerg[n5][n5];
            d = 0.0;
            d3 = 0.0;
            if (n2 < n5) {
                d = this.m_aHessenBerg[n5 - 1][n5 - 1];
                d3 = this.m_aHessenBerg[n5][n5 - 1] * this.m_aHessenBerg[n5 - 1][n5];
            }
            if (n3 == 10) {
                d4 += d2;
                n = 0;
                while (n <= n5) {
                    double[] dArray = this.m_aHessenBerg[n];
                    int n8 = n++;
                    dArray[n8] = dArray[n8] - d2;
                }
                d8 = MathHelper.abs((double)this.m_aHessenBerg[n5][n5 - 1]) + MathHelper.abs((double)this.m_aHessenBerg[n5 - 1][n5 - 2]);
                d = d2 = 0.75 * d8;
                d3 = -0.4375 * d8 * d8;
            }
            if (n3 == 30) {
                d8 = (d - d2) / 2.0;
                if ((d8 = d8 * d8 + d3) > 0.0) {
                    d8 = Math.sqrt(d8);
                    if (d < d2) {
                        d8 = -d8;
                    }
                    d8 = d2 - d3 / ((d - d2) / 2.0 + d8);
                    n = 0;
                    while (n <= n5) {
                        double[] dArray = this.m_aHessenBerg[n];
                        int n9 = n++;
                        dArray[n9] = dArray[n9] - d8;
                    }
                    d4 += d8;
                    d = d2 = 0.964;
                    d3 = d2;
                }
            }
            ++n3;
            for (n = n5 - 2; n >= n2; --n) {
                d9 = this.m_aHessenBerg[n][n];
                d7 = d2 - d9;
                d8 = d - d9;
                d5 = (d7 * d8 - d3) / this.m_aHessenBerg[n + 1][n] + this.m_aHessenBerg[n][n + 1];
                d6 = this.m_aHessenBerg[n + 1][n + 1] - d9 - d7 - d8;
                d7 = this.m_aHessenBerg[n + 2][n + 1];
                d8 = MathHelper.abs((double)d5) + MathHelper.abs((double)d6) + MathHelper.abs((double)d7);
                if (n == n2 || MathHelper.abs((double)this.m_aHessenBerg[n][n - 1]) * (MathHelper.abs((double)(d6 /= d8)) + MathHelper.abs((double)(d7 /= d8))) < EPSILON * (MathHelper.abs((double)(d5 /= d8)) * (MathHelper.abs((double)this.m_aHessenBerg[n - 1][n - 1]) + MathHelper.abs((double)d9) + MathHelper.abs((double)this.m_aHessenBerg[n + 1][n + 1])))) break;
            }
            for (n7 = n + 2; n7 <= n5; ++n7) {
                this.m_aHessenBerg[n7][n7 - 2] = 0.0;
                if (n7 <= n + 2) continue;
                this.m_aHessenBerg[n7][n7 - 3] = 0.0;
            }
            for (n7 = n; n7 <= n5 - 1; ++n7) {
                int n10;
                boolean bl;
                boolean bl2 = bl = n7 != n5 - 1;
                if (n7 != n) {
                    d5 = this.m_aHessenBerg[n7][n7 - 1];
                    d6 = this.m_aHessenBerg[n7 + 1][n7 - 1];
                    d7 = bl ? this.m_aHessenBerg[n7 + 2][n7 - 1] : 0.0;
                    d2 = MathHelper.abs((double)d5) + MathHelper.abs((double)d6) + MathHelper.abs((double)d7);
                    if (d2 == 0.0) continue;
                    d5 /= d2;
                    d6 /= d2;
                    d7 /= d2;
                }
                d8 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
                if (d5 < 0.0) {
                    d8 = -d8;
                }
                if (d8 == 0.0) continue;
                if (n7 != n) {
                    this.m_aHessenBerg[n7][n7 - 1] = -d8 * d2;
                } else if (n2 != n) {
                    this.m_aHessenBerg[n7][n7 - 1] = -this.m_aHessenBerg[n7][n7 - 1];
                }
                d2 = (d5 += d8) / d8;
                d = d6 / d8;
                d9 = d7 / d8;
                d6 /= d5;
                d7 /= d5;
                for (n10 = n7; n10 < n4; ++n10) {
                    d5 = this.m_aHessenBerg[n7][n10] + d6 * this.m_aHessenBerg[n7 + 1][n10];
                    if (bl) {
                        this.m_aHessenBerg[n7 + 2][n10] = this.m_aHessenBerg[n7 + 2][n10] - (d5 += d7 * this.m_aHessenBerg[n7 + 2][n10]) * d9;
                    }
                    this.m_aHessenBerg[n7][n10] = this.m_aHessenBerg[n7][n10] - d5 * d2;
                    this.m_aHessenBerg[n7 + 1][n10] = this.m_aHessenBerg[n7 + 1][n10] - d5 * d;
                }
                for (n10 = 0; n10 <= Math.min(n5, n7 + 3); ++n10) {
                    d5 = d2 * this.m_aHessenBerg[n10][n7] + d * this.m_aHessenBerg[n10][n7 + 1];
                    if (bl) {
                        this.m_aHessenBerg[n10][n7 + 2] = this.m_aHessenBerg[n10][n7 + 2] - (d5 += d9 * this.m_aHessenBerg[n10][n7 + 2]) * d7;
                    }
                    this.m_aHessenBerg[n10][n7] = this.m_aHessenBerg[n10][n7] - d5;
                    this.m_aHessenBerg[n10][n7 + 1] = this.m_aHessenBerg[n10][n7 + 1] - d5 * d6;
                }
                for (n10 = 0; n10 <= n6; ++n10) {
                    d5 = d2 * this.m_aEigenVector[n10][n7] + d * this.m_aEigenVector[n10][n7 + 1];
                    if (bl) {
                        this.m_aEigenVector[n10][n7 + 2] = this.m_aEigenVector[n10][n7 + 2] - (d5 += d9 * this.m_aEigenVector[n10][n7 + 2]) * d7;
                    }
                    this.m_aEigenVector[n10][n7] = this.m_aEigenVector[n10][n7] - d5;
                    this.m_aEigenVector[n10][n7 + 1] = this.m_aEigenVector[n10][n7 + 1] - d5 * d6;
                }
            }
        }
        if (d10 == 0.0) {
            return;
        }
        for (n5 = n4 - 1; n5 >= 0; --n5) {
            double d11;
            d5 = this.m_aEVd[n5];
            d6 = this.m_aEVe[n5];
            if (d6 == 0.0) {
                n2 = n5;
                this.m_aHessenBerg[n5][n5] = 1.0;
                for (n = n5 - 1; n >= 0; --n) {
                    int n11;
                    d3 = this.m_aHessenBerg[n][n] - d5;
                    d7 = 0.0;
                    for (n11 = n2; n11 <= n5; ++n11) {
                        d7 += this.m_aHessenBerg[n][n11] * this.m_aHessenBerg[n11][n5];
                    }
                    if (this.m_aEVe[n] < 0.0) {
                        d9 = d3;
                        d8 = d7;
                        continue;
                    }
                    n2 = n;
                    if (this.m_aEVe[n] == 0.0) {
                        this.m_aHessenBerg[n][n5] = d3 != 0.0 ? -d7 / d3 : -d7 / (EPSILON * d10);
                    } else {
                        d2 = this.m_aHessenBerg[n][n + 1];
                        d = this.m_aHessenBerg[n + 1][n];
                        d6 = (this.m_aEVd[n] - d5) * (this.m_aEVd[n] - d5) + this.m_aEVe[n] * this.m_aEVe[n];
                        this.m_aHessenBerg[n][n5] = d11 = (d2 * d8 - d9 * d7) / d6;
                        this.m_aHessenBerg[n + 1][n5] = MathHelper.abs((double)d2) > MathHelper.abs((double)d9) ? (-d7 - d3 * d11) / d2 : (-d8 - d * d11) / d9;
                    }
                    d11 = MathHelper.abs((double)this.m_aHessenBerg[n][n5]);
                    if (!(EPSILON * d11 * d11 > 1.0)) continue;
                    for (n11 = n; n11 <= n5; ++n11) {
                        this.m_aHessenBerg[n11][n5] = this.m_aHessenBerg[n11][n5] / d11;
                    }
                }
                continue;
            }
            if (!(d6 < 0.0)) continue;
            n2 = n5 - 1;
            if (MathHelper.abs((double)this.m_aHessenBerg[n5][n5 - 1]) > MathHelper.abs((double)this.m_aHessenBerg[n5 - 1][n5])) {
                this.m_aHessenBerg[n5 - 1][n5 - 1] = d6 / this.m_aHessenBerg[n5][n5 - 1];
                this.m_aHessenBerg[n5 - 1][n5] = -(this.m_aHessenBerg[n5][n5] - d5) / this.m_aHessenBerg[n5][n5 - 1];
            } else {
                this._cdiv(0.0, -this.m_aHessenBerg[n5 - 1][n5], this.m_aHessenBerg[n5 - 1][n5 - 1] - d5, d6);
                this.m_aHessenBerg[n5 - 1][n5 - 1] = this.m_dCdivr;
                this.m_aHessenBerg[n5 - 1][n5] = this.m_dCdivi;
            }
            this.m_aHessenBerg[n5][n5 - 1] = 0.0;
            this.m_aHessenBerg[n5][n5] = 1.0;
            for (n = n5 - 2; n >= 0; --n) {
                int n12;
                double d12 = 0.0;
                double d13 = 0.0;
                for (n12 = n2; n12 <= n5; ++n12) {
                    d12 += this.m_aHessenBerg[n][n12] * this.m_aHessenBerg[n12][n5 - 1];
                    d13 += this.m_aHessenBerg[n][n12] * this.m_aHessenBerg[n12][n5];
                }
                d3 = this.m_aHessenBerg[n][n] - d5;
                if (this.m_aEVe[n] < 0.0) {
                    d9 = d3;
                    d7 = d12;
                    d8 = d13;
                    continue;
                }
                n2 = n;
                if (this.m_aEVe[n] == 0.0) {
                    this._cdiv(-d12, -d13, d3, d6);
                    this.m_aHessenBerg[n][n5 - 1] = this.m_dCdivr;
                    this.m_aHessenBerg[n][n5] = this.m_dCdivi;
                } else {
                    d2 = this.m_aHessenBerg[n][n + 1];
                    d = this.m_aHessenBerg[n + 1][n];
                    double d14 = (this.m_aEVd[n] - d5) * (this.m_aEVd[n] - d5) + this.m_aEVe[n] * this.m_aEVe[n] - d6 * d6;
                    double d15 = (this.m_aEVd[n] - d5) * 2.0 * d6;
                    if (d14 == 0.0 && d15 == 0.0) {
                        d14 = EPSILON * d10 * (MathHelper.abs((double)d3) + MathHelper.abs((double)d6) + MathHelper.abs((double)d2) + MathHelper.abs((double)d) + MathHelper.abs((double)d9));
                    }
                    this._cdiv(d2 * d7 - d9 * d12 + d6 * d13, d2 * d8 - d9 * d13 - d6 * d12, d14, d15);
                    this.m_aHessenBerg[n][n5 - 1] = this.m_dCdivr;
                    this.m_aHessenBerg[n][n5] = this.m_dCdivi;
                    if (MathHelper.abs((double)d2) > MathHelper.abs((double)d9) + MathHelper.abs((double)d6)) {
                        this.m_aHessenBerg[n + 1][n5 - 1] = (-d12 - d3 * this.m_aHessenBerg[n][n5 - 1] + d6 * this.m_aHessenBerg[n][n5]) / d2;
                        this.m_aHessenBerg[n + 1][n5] = (-d13 - d3 * this.m_aHessenBerg[n][n5] - d6 * this.m_aHessenBerg[n][n5 - 1]) / d2;
                    } else {
                        this._cdiv(-d7 - d * this.m_aHessenBerg[n][n5 - 1], -d8 - d * this.m_aHessenBerg[n][n5], d9, d6);
                        this.m_aHessenBerg[n + 1][n5 - 1] = this.m_dCdivr;
                        this.m_aHessenBerg[n + 1][n5] = this.m_dCdivi;
                    }
                }
                d11 = Math.max(MathHelper.abs((double)this.m_aHessenBerg[n][n5 - 1]), MathHelper.abs((double)this.m_aHessenBerg[n][n5]));
                if (!(EPSILON * d11 * d11 > 1.0)) continue;
                for (n12 = n; n12 <= n5; ++n12) {
                    this.m_aHessenBerg[n12][n5 - 1] = this.m_aHessenBerg[n12][n5 - 1] / d11;
                    this.m_aHessenBerg[n12][n5] = this.m_aHessenBerg[n12][n5] / d11;
                }
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (n2 >= 0 && n2 <= n6) continue;
            for (n = n2; n < n4; ++n) {
                this.m_aEigenVector[n2][n] = this.m_aHessenBerg[n2][n];
            }
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            for (n = 0; n <= n6; ++n) {
                d9 = 0.0;
                for (int i = 0; i <= Math.min(n2, n6); ++i) {
                    d9 += this.m_aEigenVector[n][i] * this.m_aHessenBerg[i][n2];
                }
                this.m_aEigenVector[n][n2] = d9;
            }
        }
    }

    public EigenvalueDecomposition(@Nonnull Matrix matrix) {
        double[] dArray;
        int n;
        double[][] dArray2 = matrix.internalGetArray();
        this.m_nDim = matrix.getColumnDimension();
        this.m_aEigenVector = new double[this.m_nDim][this.m_nDim];
        this.m_aEVd = new double[this.m_nDim];
        this.m_aEVe = new double[this.m_nDim];
        boolean bl = true;
        block0: for (n = 0; n < this.m_nDim; ++n) {
            dArray = dArray2[n];
            for (int i = 0; i < this.m_nDim; ++i) {
                if (EqualsHelper.equals((double)dArray[i], (double)dArray2[i][n])) continue;
                bl = false;
                continue block0;
            }
        }
        this.m_bIsSymmetric = bl;
        if (this.m_bIsSymmetric) {
            for (n = 0; n < this.m_nDim; ++n) {
                dArray = dArray2[n];
                System.arraycopy(dArray, 0, this.m_aEigenVector[n], 0, dArray.length);
            }
            this._symmetricTred2();
            this._symmetricTql2();
        } else {
            this.m_aHessenBerg = new double[this.m_nDim][this.m_nDim];
            this.m_aOrt = new double[this.m_nDim];
            for (n = 0; n < this.m_nDim; ++n) {
                dArray = dArray2[n];
                double[] dArray3 = this.m_aHessenBerg[n];
                for (int i = 0; i < this.m_nDim; ++i) {
                    dArray3[i] = dArray[i];
                }
            }
            this._nonsymetricOrthes();
            this._nonsymetricHqr2();
        }
    }

    public boolean isSymmetric() {
        return this.m_bIsSymmetric;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getV() {
        return new Matrix(this.m_aEigenVector, this.m_nDim, this.m_nDim);
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    @ReturnsMutableObject(value="took code as is")
    public double[] directGetRealEigenvalues() {
        return this.m_aEVd;
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    @ReturnsMutableObject(value="took code as is")
    public double[] directGetImagEigenvalues() {
        return this.m_aEVe;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getD() {
        Matrix matrix = new Matrix(this.m_nDim, this.m_nDim);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < this.m_nDim; ++i) {
            double[] dArray2 = dArray[i];
            Arrays.fill(dArray2, 0.0);
            dArray2[i] = this.m_aEVd[i];
            double d = this.m_aEVe[i];
            if (d > 0.0) {
                dArray2[i + 1] = d;
                continue;
            }
            if (!(d < 0.0)) continue;
            dArray2[i - 1] = d;
        }
        return matrix;
    }
}

