/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.authenticator;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConstantAuthenticator
extends Authenticator {
    public static final String DOMAIN_SEPARATOR = "\\";
    private final String m_sUserName;
    private final String m_sPassword;

    public ConstantAuthenticator(@Nullable String string, @Nonnull String string2, @Nonnull String string3) {
        this(StringHelper.getConcatenatedOnDemand((String)string, (String)DOMAIN_SEPARATOR, (String)string2), string3);
    }

    public ConstantAuthenticator(@Nonnull String string, @Nonnull String string2) {
        this.m_sUserName = (String)ValueEnforcer.notNull((Object)string, (String)"UserName");
        this.m_sPassword = (String)ValueEnforcer.notNull((Object)string2, (String)"Password");
    }

    @Nonnull
    public String getUserName() {
        return this.m_sUserName;
    }

    @Nonnull
    public String getPassword() {
        return this.m_sPassword;
    }

    @Override
    public PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.m_sUserName, this.m_sPassword.toCharArray());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("userName", (Object)this.m_sUserName).appendPassword("password").getToString();
    }
}

